/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.INonExhaustiveDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StackList
implements IConcreteDeliverable,
INonExhaustiveDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(StackList.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_STACK_LIST = "StackList";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_RESULT = "Result";
    private static final String TAG_DESCRIPTION = "Desc";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    private static final String NBT_LEFTOVER = "leftover";
    @NotNull
    private final List<ItemStack> theStacks = new ArrayList<ItemStack>();
    private boolean matchMeta;
    private boolean matchNBT;
    private boolean matchOreDic;
    private final String description;
    @NotNull
    private ItemStack result;
    private int count;
    private int minCount;
    private int leftOver;

    public StackList(@NotNull List<ItemStack> stacks, String description, int count) {
        this(stacks, description, count, count);
    }

    public StackList(@NotNull List<ItemStack> stacks, String description, int count, int minCount) {
        this(stacks, true, true, false, ItemStackUtils.EMPTY, description, count, minCount, 0);
    }

    public StackList(@NotNull List<ItemStack> stacks, String description, int count, int minCount, int leftOver) {
        this(stacks, true, true, false, ItemStackUtils.EMPTY, description, count, minCount, leftOver);
    }

    public StackList(@NotNull List<ItemStack> stacks, boolean matchMeta, boolean matchNBT, boolean matchOreDic, @NotNull ItemStack result, String description, int count, int minCount, int leftOver) {
        this.description = description;
        for (ItemStack stack : stacks) {
            ItemStack tempStack = stack.copy();
            tempStack.setCount(Math.min(tempStack.getCount(), tempStack.getMaxStackSize()));
            this.theStacks.add(tempStack);
        }
        this.matchMeta = matchMeta;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
        this.leftOver = leftOver;
    }

    public static CompoundTag serialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, StackList input) {
        CompoundTag compound = new CompoundTag();
        @NotNull ListTag neededResTagList = new ListTag();
        for (ItemStack resource : input.theStacks) {
            neededResTagList.add((Object)resource.saveOptional(provider));
        }
        compound.put(NBT_STACK_LIST, (Tag)neededResTagList);
        compound.putBoolean(NBT_MATCHMETA, input.matchMeta);
        compound.putBoolean(NBT_MATCHNBT, input.matchNBT);
        compound.putBoolean(NBT_MATCHOREDIC, input.matchOreDic);
        if (!ItemStackUtils.isEmpty(input.result)) {
            compound.put(NBT_RESULT, input.result.saveOptional(provider));
        }
        compound.putString(TAG_DESCRIPTION, input.description);
        compound.putInt(NBT_COUNT, input.getCount());
        compound.putInt(NBT_MINCOUNT, input.getMinimumCount());
        compound.putInt(NBT_LEFTOVER, input.getLeftOver());
        return compound;
    }

    public static StackList deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        int count;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag neededResTagList = compound.getList(NBT_STACK_LIST, 10);
        for (int i = 0; i < neededResTagList.size(); ++i) {
            CompoundTag neededRes = neededResTagList.getCompound(i);
            stacks.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)neededRes));
        }
        boolean matchMeta = compound.getBoolean(NBT_MATCHMETA);
        boolean matchNBT = compound.getBoolean(NBT_MATCHNBT);
        boolean matchOreDic = compound.getBoolean(NBT_MATCHOREDIC);
        ItemStack result = compound.contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.getCompound(NBT_RESULT), provider) : ItemStackUtils.EMPTY;
        String desc = compound.contains(TAG_DESCRIPTION) ? compound.getString(TAG_DESCRIPTION) : "com.minecolonies.coremod.request.stacklist";
        int minCount = count = stacks.isEmpty() ? 0 : ((ItemStack)stacks.get(0)).getCount();
        if (compound.contains(NBT_COUNT)) {
            count = compound.getInt(NBT_COUNT);
            minCount = compound.getInt(NBT_MINCOUNT);
        }
        int leftOver = compound.getInt(NBT_LEFTOVER);
        return new StackList(stacks, matchMeta, matchNBT, matchOreDic, result, desc, count, minCount, leftOver);
    }

    public static void serialize(IFactoryController controller, RegistryFriendlyByteBuf buffer, StackList input) {
        buffer.writeInt(input.theStacks.size());
        input.theStacks.forEach(res -> Utils.serializeCodecMess(buffer, res));
        buffer.writeBoolean(input.matchMeta);
        buffer.writeBoolean(input.matchNBT);
        buffer.writeBoolean(input.matchOreDic);
        buffer.writeBoolean(!ItemStackUtils.isEmpty(input.result));
        if (!ItemStackUtils.isEmpty(input.result)) {
            Utils.serializeCodecMess(buffer, input.result);
        }
        buffer.writeUtf(input.description);
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
        buffer.writeInt(input.getLeftOver());
    }

    public static StackList deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int stacksSize = buffer.readInt();
        for (int i = 0; i < stacksSize; ++i) {
            stacks.add(Utils.deserializeCodecMess(buffer));
        }
        boolean matchMeta = buffer.readBoolean();
        boolean matchNBT = buffer.readBoolean();
        boolean matchOreDic = buffer.readBoolean();
        ItemStack result = buffer.readBoolean() ? Utils.deserializeCodecMess(buffer) : ItemStack.EMPTY;
        String desc = buffer.readUtf(Short.MAX_VALUE);
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        int leftOver = buffer.readInt();
        return new StackList(stacks, matchMeta, matchNBT, matchOreDic, result, desc, count, minCount, leftOver);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic) {
            for (ItemStack tempStack : this.theStacks) {
                if (Collections.disjoint(stack.getTags().toList(), tempStack.getTags().toList())) continue;
                return true;
            }
        }
        return ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), stack, this.matchMeta, this.matchNBT);
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getLeftOver() {
        return this.leftOver;
    }

    @NotNull
    public List<ItemStack> getStacks() {
        return this.theStacks;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new StackList(this.theStacks, this.matchMeta, this.matchNBT, this.matchOreDic, this.result, this.description, newCount, this.minCount, this.leftOver);
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackList)) {
            return false;
        }
        StackList stack1 = (StackList)o;
        if (this.matchMeta != stack1.matchMeta) {
            return false;
        }
        if (this.matchNBT != stack1.matchNBT) {
            return false;
        }
        if (this.matchOreDic != stack1.matchOreDic) {
            return false;
        }
        for (ItemStack tempStack : stack1.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), tempStack)) continue;
            return false;
        }
        for (ItemStack tempStack : this.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(stack1.getStacks(), tempStack)) continue;
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), stack1.getResult());
    }

    public int hashCode() {
        int result1 = this.getStacks().hashCode();
        result1 = 31 * result1 + (this.matchMeta ? 1 : 0);
        result1 = 31 * result1 + (this.matchNBT ? 1 : 0);
        result1 = 31 * result1 + (this.matchOreDic ? 1 : 0);
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ItemStack> getRequestedItems() {
        return this.theStacks;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

