/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColonyBlock<B extends AbstractColonyBlock<B>>
extends AbstractBlockMinecolonies<B>
implements IBuilderUndestroyable,
ITickableBlockMinecolonies {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final float HARDNESS = 10.0f;
    public static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final String name;
    private long lastBreakTickWarn = 0L;

    public AbstractColonyBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(10.0f, Float.POSITIVE_INFINITY).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public float getDestroyProgress(BlockState state, @NotNull Player player, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        IBuilding building = IColonyManager.getInstance().getBuilding(player.level(), pos);
        if (building != null && !building.getChildren().isEmpty() && player.level().getGameTime() - this.lastBreakTickWarn < 100L) {
            this.lastBreakTickWarn = player.level().getGameTime();
            MessageUtils.format("block.minecolonies.blockhut.breakwarn.children", new Object[0]).sendTo(player);
        }
        return ((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).pvp_mode.get() != false ? 0.025f : 0.1f) / 30.0f;
    }

    public AbstractColonyBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public abstract String getHutName();

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        TileEntityColonyBuilding building = (TileEntityColonyBuilding)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()).create(blockPos, blockState);
        building.registryName = this.getBuildingEntry().getRegistryName();
        return building;
    }

    public abstract BuildingEntry getBuildingEntry();

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.isClientSide) {
            TileEntityColonyBuilding te;
            if (hand == InteractionHand.OFF_HAND) {
                return ItemInteractionResult.FAIL;
            }
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.dimension(), pos);
            LevelChunk chunk = worldIn.getChunkAt(pos);
            BlockEntity entity = worldIn.getBlockEntity(pos);
            if (entity instanceof TileEntityColonyBuilding && (te = (TileEntityColonyBuilding)entity).getPositionedTags().containsKey(BlockPos.ZERO) && te.getPositionedTags().get(BlockPos.ZERO).contains("deactivated")) {
                if (building == null && ColonyUtils.getOwningColony((ChunkAccess)chunk) == 0) {
                    MessageUtils.format("com.minecolonies.coremod.building.missingcolony", new Object[0]).sendTo(player);
                    return ItemInteractionResult.FAIL;
                }
                if (building == null && ColonyUtils.getAllClaimingBuildings((ChunkAccess)chunk).values().stream().flatMap(Collection::stream).noneMatch(p -> p.equals((Object)pos))) {
                    IColonyManager.getInstance().openReactivationWindow(pos);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (building == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            if (building.getColony() == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nocolony", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            if (!building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return ItemInteractionResult.FAIL;
            }
            building.openGui(player.isShiftKeyDown());
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        @NotNull Direction facing = context.getPlayer() == null ? Direction.NORTH : Direction.fromYRot((double)context.getPlayer().getYRot());
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            IColony colony;
            @NotNull TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (hut.getBuildingName() != this.getBuildingEntry().getRegistryName()) {
                hut.registryName = this.getBuildingEntry().getRegistryName();
            }
            if ((colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition())) != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", this.getHutName());
    }

    @Override
    public B registerBlock(Registry<Block> registry) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)this);
        return (B)this;
    }
}

