/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.UUID;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.event.CartLockdownEvent;
import mods.railcraft.api.track.LockingTrack;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingMode;
import mods.railcraft.world.level.block.track.outfitted.LockingModeController;
import mods.railcraft.world.level.block.track.outfitted.LockingTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class LockingTrackBlockEntity
extends RailcraftBlockEntity
implements LockingTrack {
    private static final int TRAIN_LOCKDOWN_DELAY = 200;
    public static final double START_BOOST = 0.04;
    public static final double BOOST_FACTOR = 0.06;
    private UUID lockId = UUID.randomUUID();
    private LockingModeController lockingModeController;
    @Nullable
    protected AbstractMinecart currentCart;
    @Nullable
    protected AbstractMinecart prevCart;
    @Nullable
    private UUID prevCartId;
    @Nullable
    private UUID currentCartId;
    @Nullable
    protected Train currentTrain;
    protected boolean trainLeaving;
    protected boolean locked;
    private int trainDelay;

    public LockingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get(), blockPos, blockState);
        this.lockingModeController = LockingTrackBlock.getLockingMode(blockState).create(this);
    }

    public void setLockingModeController(LockingModeController lockingModeController) {
        this.lockingModeController = lockingModeController;
    }

    public void onLoad() {
        super.onLoad();
        this.prevCart = MinecartUtil.getCartFromUUID(this.level, this.prevCartId);
        this.currentCart = MinecartUtil.getCartFromUUID(this.level, this.currentCartId);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, LockingTrackBlockEntity blockEntity) {
        boolean changed = false;
        if (blockEntity.currentCart != null && !blockEntity.currentCart.isAlive()) {
            blockEntity.releaseCurrentCart();
            blockEntity.currentCart = null;
            changed = true;
        }
        boolean lastLocked = blockEntity.locked;
        blockEntity.calculateLocked();
        if (lastLocked != blockEntity.locked) {
            changed = true;
        }
        if (blockEntity.locked) {
            blockEntity.lockCurrentCart();
        } else {
            blockEntity.releaseCurrentCart();
        }
        if (blockEntity.currentCart != null) {
            blockEntity.prevCart = blockEntity.currentCart;
        }
        blockEntity.currentCart = null;
        if (changed) {
            blockEntity.setChanged();
            blockEntity.syncToClient();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.releaseCart();
    }

    private void lockCurrentCart() {
        if (this.currentCart != null) {
            RollingStock rollingStock = RollingStock.getOrThrow(this.currentCart);
            rollingStock.checkHighSpeed(this.blockPos());
            Train train = rollingStock.train();
            if (this.currentTrain != train && this.currentTrain != null) {
                this.currentTrain.removeLock(this.lockId);
            }
            this.currentTrain = train;
            if (this.currentTrain != null) {
                this.currentTrain.addLock(this.lockId);
            }
            NeoForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(this.currentCart, this.getBlockPos()));
            this.lockingModeController.locked(this.currentCart);
            this.currentCart.setDeltaMovement(0.0, this.currentCart.getDeltaMovement().y(), 0.0);
            RailShape railShape = TrackBlock.getRailShapeRaw(this.getBlockState());
            if (RailShapeUtil.isNorthSouth(railShape)) {
                this.currentCart.setPos(this.currentCart.getX(), this.currentCart.getY(), (double)this.getBlockPos().getZ() + 0.5);
            } else {
                this.currentCart.setPos((double)this.getBlockPos().getX() + 0.5, this.currentCart.getY(), this.currentCart.getZ());
            }
        }
    }

    public void minecartPassed(AbstractMinecart cart) {
        this.currentCart = cart;
        this.lockingModeController.passed(this.currentCart);
    }

    private void releaseCurrentCart() {
        if (this.currentTrain != null) {
            this.currentTrain.removeLock(this.lockId);
        }
        if (this.currentCart != null) {
            NeoForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(this.currentCart, this.getBlockPos()));
            this.lockingModeController.released(this.currentCart);
        }
    }

    @Override
    public void releaseCart() {
        this.trainLeaving = true;
    }

    @Override
    public boolean isCartLocked(AbstractMinecart cart) {
        return this.locked && this.prevCart == cart;
    }

    private boolean isSameTrainOrCart() {
        LockingMode lockingMode = LockingTrackBlock.getLockingMode(this.getBlockState());
        if (lockingMode.getLockType().isTrain()) {
            if (this.currentCart != null && this.currentCart.isAlive() && this.prevCart != null && this.prevCart.isAlive()) {
                RollingStock prevRollingStock;
                RollingStock rollingStock = RollingStock.getOrThrow(this.currentCart);
                this.trainDelay = rollingStock.isSameTrainAs(prevRollingStock = RollingStock.getOrThrow(this.prevCart)) ? 200 : 0;
            } else if (this.trainLeaving && this.prevCart != null && this.prevCart.isAlive()) {
                RollingStock prevRollingStock = RollingStock.getOrThrow(this.prevCart);
                if (EntitySearcher.findMinecarts().at(this.getBlockPos()).stream(this.level).map(RollingStock::getOrThrow).anyMatch(cart -> cart.isSameTrainAs(prevRollingStock))) {
                    this.trainDelay = 200;
                }
            }
            if (this.trainDelay > 0) {
                --this.trainDelay;
            } else {
                this.prevCart = null;
            }
            return this.trainDelay > 0;
        }
        return this.currentCart != null && lockingMode.getLockType().isCart() && this.currentCart == this.prevCart;
    }

    private void calculateLocked() {
        boolean powered = LockingTrackBlock.isPowered(this.getBlockState());
        boolean sameTrainOrCart = this.isSameTrainOrCart();
        if (this.trainLeaving) {
            boolean bl = this.locked = !sameTrainOrCart && !powered;
            if (this.locked) {
                this.trainLeaving = false;
            }
        } else {
            boolean bl = this.locked = !powered;
            if (!this.locked && sameTrainOrCart) {
                this.trainLeaving = true;
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("lockingModeController", (Tag)this.lockingModeController.serializeNBT(provider));
        tag.putBoolean("locked", this.locked);
        tag.putBoolean("trainLeaving", this.trainLeaving);
        tag.putInt("trainDelay", this.trainDelay);
        if (this.prevCart != null) {
            tag.putUUID("prevCartId", this.prevCart.getUUID());
        }
        if (this.currentCart != null) {
            tag.putUUID("currentCartId", this.currentCart.getUUID());
        }
        tag.putUUID("lockId", this.lockId);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lockingModeController = LockingTrackBlock.getLockingMode(this.getBlockState()).create(this);
        this.lockingModeController.deserializeNBT(provider, tag.getCompound("lockingModeController"));
        this.locked = tag.getBoolean("locked");
        this.trainLeaving = tag.getBoolean("trainLeaving");
        this.trainDelay = tag.getInt("trainDelay");
        if (tag.hasUUID("prevCartId")) {
            this.prevCartId = tag.getUUID("prevCartId");
        }
        if (tag.hasUUID("currentCartId")) {
            this.currentCartId = tag.getUUID("currentCartId");
        }
        this.lockId = tag.getUUID("lockId");
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.locked);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.locked = data.readBoolean();
    }
}

