/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.world.inventory.slot.OutputSlot;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.ItemManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ItemUnloaderBlockEntity
extends ItemManipulatorBlockEntity {
    private static final Set<ManipulatorBlockEntity.RedstoneMode> SUPPORTED_REDSTONE_MODES = Collections.unmodifiableSet(EnumSet.of(ManipulatorBlockEntity.RedstoneMode.IMMEDIATE, ManipulatorBlockEntity.RedstoneMode.COMPLETE, ManipulatorBlockEntity.RedstoneMode.MANUAL));

    public ItemUnloaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ITEM_UNLOADER.get(), blockPos, blockState);
    }

    @Override
    public Set<ManipulatorBlockEntity.RedstoneMode> getSupportedRedstoneModes() {
        return SUPPORTED_REDSTONE_MODES;
    }

    @Override
    public ContainerManipulator<?> getSource() {
        return this.cart;
    }

    @Override
    public ContainerManipulator<?> getDestination() {
        return this.chests;
    }

    @Override
    public Slot getBufferSlot(int id, int x, int y) {
        return new OutputSlot(this, id, x, y);
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        this.clearContainer();
    }

    @Override
    public boolean canHandleCart(AbstractMinecart cart) {
        return super.canHandleCart(cart) && Optional.ofNullable(ItemUnloaderBlockEntity.getCartItemHandler(cart, this.getFacing().getOpposite())).map(ContainerManipulator::of).map(ContainerManipulator::hasItems).orElse(false) != false;
    }

    private void clearContainer() {
        if (this.bufferContainer.hasItems()) {
            this.bufferContainer.moveOneItemTo(this.findAdjacentContainers());
        }
    }
}

