/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.Optional;
import mods.railcraft.api.carts.ItemTransferHandler;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.season.Season;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.SeasonalCart;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftMinecart
extends AbstractMinecartContainer
implements SeasonalCart,
ItemTransferHandler {
    private static final EntityDataAccessor<Season> SEASON = SynchedEntityData.defineId(RailcraftMinecart.class, RailcraftDataSerializers.MINECART_SEASON);
    private final Direction[] travelDirectionHistory = new Direction[2];
    @Nullable
    private Direction travelDirection;
    @Nullable
    private Direction verticalTravelDirection;

    protected RailcraftMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected RailcraftMinecart(EntityType<TunnelBore> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    protected RailcraftMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
        this.loadCustomName(itemStack);
    }

    private void loadCustomName(ItemStack itemStack) {
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            this.setCustomName(itemStack.getHoverName());
        }
    }

    protected void loadFromItemStack(ItemStack itemStack) {
    }

    public Optional<Direction> travelDirection() {
        return Optional.ofNullable(this.travelDirection);
    }

    public Optional<Direction> verticalTravelDirection() {
        return Optional.ofNullable(this.verticalTravelDirection);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SEASON, (Object)Season.DEFAULT);
    }

    @Override
    public Season getSeason() {
        return (Season)((Object)this.entityData.get(SEASON));
    }

    @Override
    public void setSeason(Season season) {
        this.entityData.set(SEASON, (Object)season);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("season", this.getSeason().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSeason(Season.fromName(tag.getString("season")));
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.hasMenu()) {
                serverPlayer.openMenu((MenuProvider)this, data -> data.writeVarInt(this.getId()));
            }
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    protected boolean hasMenu() {
        return true;
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.level().isClientSide()) {
            for (int slot = 0; slot < this.getContainerSize(); ++slot) {
                this.setItem(slot, ItemStack.EMPTY);
            }
        }
        super.remove(reason);
    }

    public final void destroy(DamageSource source) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = this.getPickResult().copy();
            if (this.hasCustomName()) {
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            this.spawnAtLocation(itemstack);
        }
        this.chestVehicleDestroyed(source, this.level(), (Entity)this);
    }

    public ItemStack getPickResult() {
        ItemStack itemStack = this.getDropItem().getDefaultInstance();
        if (this.hasCustomName()) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return itemStack;
    }

    protected Item getDropItem() {
        throw new NotImplementedException();
    }

    public AbstractMinecart.Type getMinecartType() {
        throw new UnsupportedOperationException();
    }

    public boolean isPoweredCart() {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void updateTravelDirection(BlockPos pos, BlockState state) {
        RailShape shape = TrackUtil.getTrackDirection((BlockGetter)this.level(), pos, state);
        Direction direction = this.determineTravelDirection(shape);
        Direction lastDirection = this.travelDirectionHistory[1];
        if (lastDirection != null && this.travelDirectionHistory[0] == lastDirection) {
            this.travelDirection = direction;
            this.verticalTravelDirection = this.determineVerticalTravelDirection(shape);
        }
        this.travelDirectionHistory[0] = lastDirection;
        this.travelDirectionHistory[1] = direction;
    }

    @Nullable
    private Direction determineTravelDirection(RailShape shape) {
        return switch (shape) {
            case RailShape.SOUTH_EAST -> {
                if (this.zo > this.getZ()) {
                    yield Direction.EAST;
                }
                yield Direction.SOUTH;
            }
            case RailShape.SOUTH_WEST -> {
                if (this.zo > this.getZ()) {
                    yield Direction.WEST;
                }
                yield Direction.SOUTH;
            }
            case RailShape.NORTH_WEST -> {
                if (this.zo > this.getZ()) {
                    yield Direction.NORTH;
                }
                yield Direction.WEST;
            }
            case RailShape.NORTH_EAST -> {
                if (this.zo > this.getZ()) {
                    yield Direction.NORTH;
                }
                yield Direction.EAST;
            }
            default -> this.getX() - this.xo > 0.0 ? Direction.EAST : (this.getX() - this.xo < 0.0 ? Direction.WEST : (this.getZ() - this.zo > 0.0 ? Direction.SOUTH : (this.getZ() - this.zo < 0.0 ? Direction.NORTH : null)));
        };
    }

    @Nullable
    private Direction determineVerticalTravelDirection(RailShape shape) {
        return shape.isAscending() ? (this.yo < this.getY() ? Direction.UP : Direction.DOWN) : null;
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canAcceptPushedItem(RollingStock requester, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canProvidePulledItem(RollingStock requester, ItemStack stack) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return MinecartUtil.isInRangeToRenderDist((AbstractMinecart)this, distance);
    }
}

