/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static VoxelShape[] makeShapes(VoxelShape mainShape, Map<Direction, VoxelShape> connectionShapes) {
        VoxelShape[] shapes = new VoxelShape[64];
        for (int i = 0; i < 64; ++i) {
            VoxelShape shape = mainShape;
            for (Map.Entry<Direction, VoxelShape> entry : connectionShapes.entrySet()) {
                if ((i & VoxelShapeUtil.indexFor(entry.getKey())) == 0) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)entry.getValue());
            }
            shapes[i] = shape;
        }
        return shapes;
    }

    public static Map<Direction, VoxelShape> createHorizontalShapes(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return VoxelShapeUtil.createDirectionalShapes(minX, minY, minZ, maxX, maxY, maxZ, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    }

    public static Map<Direction, VoxelShape> createDirectionalShapes(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Direction ... directions) {
        EnumMap<Direction, VoxelShape> connectionShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            connectionShapes.put(direction, Block.box((double)Math.min(minX, 8.0 + (double)direction.getStepX() * 8.0), (double)Math.min(minY, 8.0 + (double)direction.getStepY() * 8.0), (double)Math.min(minZ, 8.0 + (double)direction.getStepZ() * 8.0), (double)Math.max(maxX, 8.0 + (double)direction.getStepX() * 8.0), (double)Math.max(maxY, 8.0 + (double)direction.getStepY() * 8.0), (double)Math.max(maxZ, 8.0 + (double)direction.getStepZ() * 8.0)));
        }
        return connectionShapes;
    }

    public static int indexFor(Direction direction) {
        return 1 << direction.get3DDataValue();
    }
}

