/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetMaintenanceMinecartMessage(int entityId, MaintenanceMinecart.Mode mode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetMaintenanceMinecartMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_maintenance_minecart"));
    public static final StreamCodec<FriendlyByteBuf, SetMaintenanceMinecartMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetMaintenanceMinecartMessage::entityId, (StreamCodec)NeoForgeStreamCodecs.enumCodec(MaintenanceMinecart.Mode.class), SetMaintenanceMinecartMessage::mode, SetMaintenanceMinecartMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetMaintenanceMinecartMessage message, IPayloadContext context) {
        Level level = context.player().level();
        Entity entity = level.getEntity(message.entityId);
        if (entity instanceof MaintenanceMinecart) {
            MaintenanceMinecart minecart = (MaintenanceMinecart)entity;
            minecart.setMode(message.mode);
        }
    }
}

