/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class CrusherRecipeBuilder {
    public static final int DEFAULT_PROCESSING_TIME = 200;
    private static final int MAX_SLOTS = 9;
    private final Ingredient ingredient;
    private final List<CrusherRecipe.CrusherOutput> probabilityOutputs;
    private final int processTime;
    private final List<ICondition> conditions;

    private CrusherRecipeBuilder(Ingredient ingredient, int processTime) {
        this.ingredient = ingredient;
        this.probabilityOutputs = new ArrayList<CrusherRecipe.CrusherOutput>();
        this.processTime = processTime;
        this.conditions = new ArrayList<ICondition>();
    }

    public static CrusherRecipeBuilder crush(ItemLike ingredient) {
        return CrusherRecipeBuilder.crush(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}));
    }

    public static CrusherRecipeBuilder crush(TagKey<Item> ingredient) {
        CrusherRecipeBuilder builder = CrusherRecipeBuilder.crush(Ingredient.of(ingredient));
        builder.conditions.add((ICondition)new NotCondition((ICondition)new TagEmptyCondition(ingredient)));
        return builder;
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient) {
        return CrusherRecipeBuilder.crush(ingredient, 200);
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient, int processTime) {
        return new CrusherRecipeBuilder(ingredient, processTime);
    }

    public CrusherRecipeBuilder addResult(ItemLike output, int quantity, double probability) {
        return this.addResult(Ingredient.of((ItemLike[])new ItemLike[]{output}), quantity, probability);
    }

    public CrusherRecipeBuilder addResult(TagKey<Item> output, int quantity, double probability) {
        this.conditions.add((ICondition)new NotCondition((ICondition)new TagEmptyCondition(output)));
        return this.addResult(Ingredient.of(output), quantity, probability);
    }

    public CrusherRecipeBuilder addResult(Ingredient output, int quantity, double probability) {
        if (this.probabilityOutputs.size() >= 9) {
            throw new IllegalStateException("Reached the maximum number of available slots as a result: 9");
        }
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalStateException("The probability must be between 0 and 1! You have inserted: " + probability);
        }
        this.probabilityOutputs.add(new CrusherRecipe.CrusherOutput(output, quantity, probability));
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        Object itemPath;
        Ingredient.Value value = this.ingredient.getValues()[0];
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            String location = tagValue.tag().location().getPath().replace("/", "_");
            itemPath = "tags_" + location;
        } else {
            itemPath = Arrays.stream(this.ingredient.getItems()).filter(x -> !x.is(Items.BARRIER)).findFirst().map(x -> BuiltInRegistries.ITEM.getKey((Object)x.getItem()).getPath()).orElseThrow();
        }
        this.save(recipeOutput, (String)itemPath);
    }

    public void save(RecipeOutput recipeOutput, String path) {
        CrusherRecipe recipe = new CrusherRecipe(this.ingredient, this.probabilityOutputs, this.processTime);
        recipeOutput.withConditions((ICondition[])this.conditions.toArray(ICondition[]::new)).accept(RailcraftConstants.rl("crusher/crushing_" + path), (Recipe)recipe, null);
    }
}

