/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class RenderUtil {
    public static final int FULL_LIGHT = 0xF000F0;
    public static final float PIXEL = 0.0625f;
    public static final float SCALED_PIXEL = 0.00390625f;
    private static final Minecraft minecraft = Minecraft.getInstance();

    public static int replaceAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = RenderUtil.getColorARGB(fluidStack);
        if (fluidStack.getFluidType().isLighterThanAir()) {
            int alpha = (int)(Math.min(1.0f, fluidScale + 0.2f) * 255.0f);
            return FastColor.ARGB32.color((int)alpha, (int)FastColor.ARGB32.red((int)color), (int)FastColor.ARGB32.green((int)color), (int)FastColor.ARGB32.blue((int)color));
        }
        return color;
    }

    public static int getColorARGB(FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int calculateGlowLight(int combinedLight, FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : RenderUtil.calculateGlowLight(combinedLight, fluid.getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderBlockHoverText(BlockPos blockPos, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (RenderUtil.minecraft.hitResult != null && RenderUtil.minecraft.hitResult.getType() == HitResult.Type.BLOCK && ((BlockHitResult)RenderUtil.minecraft.hitResult).getBlockPos().equals((Object)blockPos)) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.5f, 0.5f);
            RenderUtil.renderWorldText(RenderUtil.minecraft.font, text, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
    }

    public static void renderWorldText(Font font, Component text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(RenderUtil.minecraft.gameRenderer.getMainCamera().rotation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = poseStack.last().pose();
        float backgroundOpacity = RenderUtil.minecraft.options.getBackgroundOpacity(0.25f);
        int packedOverlay = (int)(backgroundOpacity * 255.0f) << 24;
        float x = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, x, 0.0f, 0x20FFFFFF, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, packedOverlay, packedLight);
        font.drawInBatch(text, x, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }
}

