/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class ChargeSavedData
extends SavedData {
    private static final int ABSENT_VALUE = -1;
    private static final String DATA_TAG_PREFIX = "railcraft.charge.";
    private final Object2IntMap<BlockPos> chargeLevels = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));

    public static ChargeSavedData getFor(Charge network, ServerLevel level) {
        return (ChargeSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ChargeSavedData::new, (tag, provider) -> {
            ChargeSavedData manager = new ChargeSavedData();
            manager.load((CompoundTag)tag);
            return manager;
        }), DATA_TAG_PREFIX + network.getSerializedName());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag batteriesTag = new ListTag();
        for (Object2IntMap.Entry entry : this.chargeLevels.object2IntEntrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("pos", NbtUtils.writeBlockPos((BlockPos)((BlockPos)entry.getKey())));
            entryTag.putInt("value", entry.getIntValue());
            batteriesTag.add((Object)entryTag);
        }
        tag.put("batteries", (Tag)batteriesTag);
        return tag;
    }

    private void load(CompoundTag tag) {
        ListTag batteriesTag = tag.getList("batteries", 10);
        for (int i = 0; i < batteriesTag.size(); ++i) {
            CompoundTag entryTag = batteriesTag.getCompound(i);
            NbtUtils.readBlockPos((CompoundTag)entryTag, (String)"pos").ifPresent(pos -> this.chargeLevels.put(pos, entryTag.getInt("value")));
        }
    }

    public void initBattery(ChargeStorageBlockImpl battery) {
        battery.setEnergyStored(this.chargeLevels.computeIfAbsent((Object)battery.getBlockPos(), __ -> battery.getInitialCharge()));
        this.setDirty();
    }

    public void updateBatteryRecord(ChargeStorageBlockImpl battery) {
        this.chargeLevels.put((Object)battery.getBlockPos(), battery.getEnergyStored());
        this.setDirty();
    }

    public void removeBattery(BlockPos pos) {
        if (this.chargeLevels.removeInt((Object)pos) != -1) {
            this.setDirty();
        }
    }
}

