/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.wixie;

import com.hollingsworth.arsnouveau.api.recipe.CraftingManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidCraftManager
extends CraftingManager {
    public List<FluidStack> neededFluids = new ArrayList<FluidStack>();

    public FluidCraftManager(ItemStack outputStack, List<ItemStack> neededItems, List<FluidStack> neededFluids) {
        super(outputStack, neededItems);
        this.neededFluids = neededFluids;
    }

    public FluidStack getNextFluid() {
        return !this.neededFluids.isEmpty() ? this.neededFluids.getFirst() : FluidStack.EMPTY;
    }

    public FluidStack getNeededFluid() {
        return FluidStack.EMPTY;
    }

    public boolean canBeCompleted() {
        return this.neededItems.isEmpty() && this.neededFluids.isEmpty();
    }

    public boolean giveFluid(FluidStack fluidStack) {
        if (this.canBeCompleted()) {
            return false;
        }
        FluidStack stackToRemove = FluidStack.EMPTY;
        for (FluidStack stack : this.neededFluids) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)fluidStack)) continue;
            stackToRemove = stack;
            break;
        }
        return this.neededFluids.remove(stackToRemove);
    }
}

