/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekmm.common.attachments.component.MMAttachedSideConfig;
import com.jerry.mekmm.common.block.BlockDoll;
import com.jerry.mekmm.common.block.prefab.MMBlockFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MMFactory;
import com.jerry.mekmm.common.content.blocktype.MMFactoryType;
import com.jerry.mekmm.common.content.blocktype.MMMachine;
import com.jerry.mekmm.common.item.block.ItemBlockDoll;
import com.jerry.mekmm.common.item.block.machine.MMItemBlockFactory;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.registries.MMBlockTypes;
import com.jerry.mekmm.common.tile.factory.MMTileEntityFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityReplicatingFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityAmbientGasCollector;
import com.jerry.mekmm.common.tile.machine.TileEntityChemicalReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityFluidReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityLathe;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.tile.machine.TileEntityRecycler;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityRollingMill;
import com.jerry.mekmm.common.tile.machine.TileEntityStamper;
import com.jerry.mekmm.common.util.MMEnumUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.fluid.FluidTanksBuilder;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.SingleInputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MMBlocks {
    public static final BlockDeferredRegister MM_BLOCKS = new BlockDeferredRegister("mekmm");
    private static final Table<FactoryTier, MMFactoryType, BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, MMItemBlockFactory>> MM_FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityRecycler, MMMachine.MMFactoryMachine<TileEntityRecycler>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityRecycler, MMMachine.MMFactoryMachine<TileEntityRecycler>>>> RECYCLER;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityPlantingStation, MMMachine.MMFactoryMachine<TileEntityPlantingStation>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityPlantingStation, MMMachine.MMFactoryMachine<TileEntityPlantingStation>>>> PLANTING_STATION;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityStamper, MMMachine.MMFactoryMachine<TileEntityStamper>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityStamper, MMMachine.MMFactoryMachine<TileEntityStamper>>>> CNC_STAMPER;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityLathe, MMMachine.MMFactoryMachine<TileEntityLathe>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityLathe, MMMachine.MMFactoryMachine<TileEntityLathe>>>> CNC_LATHE;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityRollingMill, MMMachine.MMFactoryMachine<TileEntityRollingMill>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityRollingMill, MMMachine.MMFactoryMachine<TileEntityRollingMill>>>> CNC_ROLLING_MILL;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityReplicator, MMMachine.MMFactoryMachine<TileEntityReplicator>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityReplicator, MMMachine.MMFactoryMachine<TileEntityReplicator>>>> REPLICATOR;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityFluidReplicator, MMMachine.MMFactoryMachine<TileEntityFluidReplicator>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityFluidReplicator, MMMachine.MMFactoryMachine<TileEntityFluidReplicator>>>> FLUID_REPLICATOR;
    public static final BlockRegistryObject<MMBlockFactoryMachine<TileEntityChemicalReplicator, MMMachine.MMFactoryMachine<TileEntityChemicalReplicator>>, ItemBlockTooltip<MMBlockFactoryMachine<TileEntityChemicalReplicator, MMMachine.MMFactoryMachine<TileEntityChemicalReplicator>>>> CHEMICAL_REPLICATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAmbientGasCollector, Machine<TileEntityAmbientGasCollector>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityAmbientGasCollector, Machine<TileEntityAmbientGasCollector>>>> AMBIENT_GAS_COLLECTOR;
    public static final BlockRegistryObject<BlockDoll, ItemBlockDoll> AUTHOR_DOLL;

    private MMBlocks() {
    }

    private static <TILE extends MMTileEntityFactory<?>> BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, MMItemBlockFactory> registerMMFactory(MMFactory<TILE> type) {
        FactoryTier tier = (FactoryTier)Objects.requireNonNull((AttributeTier)type.get(AttributeTier.class)).tier();
        BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory, MMItemBlockFactory> factory = MMBlocks.registerTieredBlock((ITier)tier, "_" + type.getMMFactoryType().getRegistryNameComponent() + "_factory", () -> new MMBlockFactoryMachine.MMBlockFactory(type), MMItemBlockFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeInputPredicate = switch (type.getMMFactoryType()) {
                default -> throw new MatchException(null, null);
                case MMFactoryType.RECYCLING -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.RECYCLING.getInputCache()).containsInput(null, s);
                case MMFactoryType.PLANTING_STATION -> s -> ((InputRecipeCache.ItemChemical)MoreMachineRecipeType.PLANTING_STATION.getInputCache()).containsInputA(null, s);
                case MMFactoryType.CNC_STAMPING -> s -> ((InputRecipeCache.DoubleItem)MoreMachineRecipeType.STAMPING.getInputCache()).containsInputA(null, s);
                case MMFactoryType.CNC_LATHING -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.LATHING.getInputCache()).containsInput(null, s);
                case MMFactoryType.CNC_ROLLING_MILL -> s -> ((InputRecipeCache.SingleItem)MoreMachineRecipeType.ROLLING_MILL.getInputCache()).containsInput(null, s);
                case MMFactoryType.REPLICATING -> TileEntityReplicator::isValidItemInput;
            };
            switch (type.getMMFactoryType()) {
                case CNC_STAMPING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInput((IMekanismRecipeTypeProvider)MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addEnergy().build());
                    break;
                }
                case RECYCLING: 
                case CNC_LATHING: 
                case CNC_ROLLING_MILL: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addEnergy().build());
                    break;
                }
                case PLANTING_STATION: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> {
                        switch (type.getMMFactoryType()) {
                            case PLANTING_STATION: {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Factory type doesn't have a known gas recipe.");
                            }
                        }
                        return ChemicalTanksBuilder.builder().addBasic(210L * (long)processes, MoreMachineRecipeType.PLANTING_STATION, DoubleInputRecipeCache::containsInputB).build();
                    }).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate, true).addChemicalFillOrConvertSlot(1).addEnergy().build());
                    break;
                }
                case REPLICATING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L * (long)processes, TileEntityReplicatingFactory::isValidChemicalInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                }
            }
        });
        return factory;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return MM_BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    public static BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, MMItemBlockFactory> getMMFactory(@NotNull FactoryTier tier, @NotNull MMFactoryType type) {
        return (BlockRegistryObject)MM_FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, MMItemBlockFactory>[] getMMFactoryBlocks() {
        return MM_FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            for (MMFactoryType type : MMEnumUtils.MM_FACTORY_TYPES) {
                MM_FACTORIES.put((Object)tier, (Object)type, MMBlocks.registerMMFactory(MMBlockTypes.getMMFactory(tier, type)));
            }
        }
        RECYCLER = MM_BLOCKS.register("recycler", () -> new MMBlockFactoryMachine(MMBlockTypes.RECYCLER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MoreMachineRecipeType.RECYCLING, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        PLANTING_STATION = MM_BLOCKS.register("planting_station", () -> new MMBlockFactoryMachine(MMBlockTypes.PLANTING_STATION, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(210L, MoreMachineRecipeType.PLANTING_STATION, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MoreMachineRecipeType.PLANTING_STATION, DoubleInputRecipeCache::containsInputA).addChemicalFillOrConvertSlot(1).addOutput().addOutput().addEnergy().build()));
        CNC_STAMPER = MM_BLOCKS.register("cnc_stamper", () -> new MMBlockFactoryMachine(MMBlockTypes.CNC_STAMPER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.EXTRA_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MoreMachineRecipeType.STAMPING, DoubleInputRecipeCache::containsInputA).addInput(MoreMachineRecipeType.STAMPING, DoubleInputRecipeCache::containsInputB).addOutput().addEnergy().build()));
        CNC_LATHE = MM_BLOCKS.register("cnc_lathe", () -> new MMBlockFactoryMachine(MMBlockTypes.CNC_LATHE, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MoreMachineRecipeType.LATHING, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        CNC_ROLLING_MILL = MM_BLOCKS.register("cnc_rolling_mill", () -> new MMBlockFactoryMachine(MMBlockTypes.CNC_ROLLING_MILL, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ELECTRIC_MACHINE))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(MoreMachineRecipeType.ROLLING_MILL, SingleInputRecipeCache::containsInput).addOutput().addEnergy().build()));
        REPLICATOR = MM_BLOCKS.register("replicator", () -> new MMBlockFactoryMachine(MMBlockTypes.REPLICATOR, properties -> properties.mapColor(MapColor.METAL)), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)AttachedSideConfig.ADVANCED_MACHINE_INPUT_ONLY))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L, TileEntityReplicator::isValidChemicalInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addInput(TileEntityReplicator::isValidItemInput).addOutput().addChemicalFillOrConvertSlot(0).addEnergy().build()));
        FLUID_REPLICATOR = MM_BLOCKS.register("fluid_replicator", () -> new MMBlockFactoryMachine(MMBlockTypes.FLUID_REPLICATOR, properties -> properties.mapColor(MapColor.METAL)), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)MMAttachedSideConfig.FLUID_REPLICATOR))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(1000, TileEntityFluidReplicator::isValidFluidInput).addBasic(10000).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(() -> 10000L, TileEntityFluidReplicator::isValidChemicalInput).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidFillSlot(0).addOutput().addFluidDrainSlot(2).addOutput().addChemicalFillOrConvertSlot(4).addEnergy().build()));
        CHEMICAL_REPLICATOR = MM_BLOCKS.register("chemical_replicator", () -> new MMBlockFactoryMachine(MMBlockTypes.CHEMICAL_REPLICATOR, properties -> properties.mapColor(MapColor.METAL)), (block, properties) -> new ItemBlockTooltip((Block)block, true, properties.component((Supplier)MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component((Supplier)MekanismDataComponents.SIDE_CONFIG, (Object)MMAttachedSideConfig.CHEMICAL_REPLICATOR))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(() -> 10000L, TileEntityChemicalReplicator::isValidChemicalInput).addBasic(() -> 10000L, TileEntityChemicalReplicator::isValidInputChemical).addBasic(() -> 10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillOrConvertSlot(0).addChemicalFillOrConvertSlot(1).addOutput().addEnergy().build()));
        AMBIENT_GAS_COLLECTOR = MM_BLOCKS.registerDetails("ambient_gas_collector", () -> new BlockTile.BlockTileModel(MMBlockTypes.AMBIENT_GAS_COLLECTOR, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()))).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(10000L).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalDrainSlot(0).addEnergy().build()));
        AUTHOR_DOLL = MM_BLOCKS.register("author_doll", () -> new BlockDoll(MMBlockTypes.AUTHOR_DOLL, properties -> properties.sound(SoundType.WOOL).destroyTime(0.0f).strength(0.0f)), ItemBlockDoll::new);
    }
}

