/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.tile.factory.MMTileEntityFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MMPacketGuiInteract
implements IMekanismPacket {
    public static final CustomPacketPayload.Type<MMPacketGuiInteract> TYPE = new CustomPacketPayload.Type(Mekmm.rl("gui_interact"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MMPacketGuiInteract> STREAM_CODEC = MMInteractionType.STREAM_CODEC.cast().dispatch(packet -> packet.interactionType, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> null;
        case 2 -> StreamCodec.composite(MMGuiInteraction.STREAM_CODEC, packet -> packet.interaction, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.tilePosition, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.extra, MMPacketGuiInteract::new);
        case 1 -> StreamCodec.composite(MMGuiInteractionItem.STREAM_CODEC, packet -> packet.itemInteraction, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.tilePosition, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, packet -> packet.extraItem, MMPacketGuiInteract::new);
    });
    private final MMInteractionType interactionType;
    private MMGuiInteraction interaction;
    private MMGuiInteractionItem itemInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public MMPacketGuiInteract(MMGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public MMPacketGuiInteract(MMGuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public MMPacketGuiInteract(MMGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public MMPacketGuiInteract(MMGuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = MMInteractionType.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public MMPacketGuiInteract(MMGuiInteractionItem interaction, BlockEntity tile, ItemStack stack) {
        this(interaction, tile.getBlockPos(), stack);
    }

    public MMPacketGuiInteract(MMGuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = MMInteractionType.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (this.interactionType == MMInteractionType.ENTITY) {
            Entity entity = player.level().getEntity(this.entityID);
        } else {
            TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.tilePosition);
            if (tile != null) {
                if (this.interactionType == MMInteractionType.INT) {
                    this.interaction.consume(tile, player, this.extra);
                } else if (this.interactionType == MMInteractionType.ITEM) {
                    this.itemInteraction.consume(tile, player, this.extraItem);
                }
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<MMPacketGuiInteract> type() {
        return TYPE;
    }

    public static enum MMGuiInteraction {
        AUTO_SORT_BUTTON((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof MMTileEntityFactory) {
                MMTileEntityFactory factory = (MMTileEntityFactory)((Object)tile);
                factory.toggleSorting();
            }
            if (tile instanceof TileEntityAdvancedFactoryBase) {
                TileEntityAdvancedFactoryBase advancedFactory = (TileEntityAdvancedFactoryBase)((Object)tile);
                advancedFactory.toggleSorting();
            }
        }));

        public static final IntFunction<MMGuiInteraction> BY_ID;
        public static final StreamCodec<ByteBuf, MMGuiInteraction> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private MMGuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MMGuiInteraction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static enum MMInteractionType {
        ENTITY,
        ITEM,
        INT;

        public static final IntFunction<MMInteractionType> BY_ID;
        public static final StreamCodec<ByteBuf, MMInteractionType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MMInteractionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum MMGuiInteractionItem {
        DUPLICATOR_INVERSE_REPLACE_ITEM((TriConsumer<TileEntityMekanism, Player, ItemStack>)((TriConsumer)(tile, player, stack) -> {
            if (tile instanceof TileEntityReplicator) {
                TileEntityReplicator tileEntityReplicator = (TileEntityReplicator)((Object)tile);
            }
        }));

        public static final IntFunction<MMGuiInteractionItem> BY_ID;
        public static final StreamCodec<ByteBuf, MMGuiInteractionItem> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile;

        private MMGuiInteractionItem(TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, ItemStack stack) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)stack);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MMGuiInteractionItem.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

