/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer.jei;

import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AFBlocks;
import java.util.List;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class AFCatalystRegistryHelper {
    private AFCatalystRegistryHelper() {
    }

    public static void register(IRecipeCatalystRegistration registry, boolean needOrdinary, IRecipeViewerRecipeType<?> ... categories) {
        for (IRecipeViewerRecipeType<?> category : categories) {
            AFCatalystRegistryHelper.register(registry, MekanismJEI.genericRecipeType(category), category.workstations(), needOrdinary);
        }
    }

    public static void register(IRecipeCatalystRegistration registry, RecipeType<?> recipeType, List<ItemLike> workstations, boolean needOrdinary) {
        for (ItemLike workstation : workstations) {
            Item item = workstation.asItem();
            if (needOrdinary) {
                registry.addRecipeCatalyst((ItemLike)item, new RecipeType[]{recipeType});
            }
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                if (workstation == MekanismBlocks.CHEMICAL_OXIDIZER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.OXIDIZING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_INFUSER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.DISSOLVING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_WASHER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.WASHING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_CRYSTALLIZER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CRYSTALLIZING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.PRESSURIZED_REACTION_CHAMBER) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.ISOTOPIC_CENTRIFUGE) {
                    registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CENTRIFUGING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation != MekanismBlocks.NUTRITIONAL_LIQUIFIER) continue;
                registry.addRecipeCatalyst(AFBlocks.getAdvancedFactory(tier, AdvancedFactoryType.LIQUIFYING), new RecipeType[]{recipeType});
            }
        }
    }
}

