/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui.element.gauge;

import com.jerry.mekmm.client.gui.element.gauge.MMGaugeType;
import com.jerry.mekmm.client.gui.element.gauge.MMGuiGauge;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerIngredientHelper;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class MMGuiTankGauge<T, TANK>
extends MMGuiGauge<T>
implements IRecipeViewerIngredientHelper {
    private final ITankInfoHandler<TANK> infoHandler;
    private final PacketDropperUse.TankType tankType;

    public MMGuiTankGauge(MMGaugeType type, IGuiWrapper gui, int x, int y, int sizeX, int sizeY, ITankInfoHandler<TANK> infoHandler, PacketDropperUse.TankType tankType) {
        super(type, gui, x, y, sizeX, sizeY);
        this.infoHandler = infoHandler;
        this.tankType = tankType;
    }

    public TANK getTank() {
        return this.infoHandler.getTank();
    }

    @Override
    protected GaugeInfo getGaugeColor() {
        IGuiWrapper iGuiWrapper = this.gui();
        if (iGuiWrapper instanceof GuiMekanismTile) {
            ISideConfiguration config;
            DataType dataType;
            TileEntityMekanism tile;
            GuiMekanismTile gui = (GuiMekanismTile)iGuiWrapper;
            TANK tank = this.getTank();
            if (tank != null && (tile = ((MekanismTileContainer)gui.getMenu()).getTileEntity()) instanceof ISideConfiguration && (dataType = (config = (ISideConfiguration)tile).getActiveDataType(tank)) != null) {
                return GaugeInfo.get((DataType)dataType);
            }
        }
        return super.getGaugeColor();
    }

    public void onClick(double mouseX, double mouseY, int button) {
        ItemStack stack = this.gui().getCarriedItem();
        IGuiWrapper iGuiWrapper = this.gui();
        if (iGuiWrapper instanceof GuiMekanismTile) {
            int index;
            GuiMekanismTile gui = (GuiMekanismTile)iGuiWrapper;
            if (!stack.isEmpty() && stack.getItem() instanceof ItemGaugeDropper && (index = this.infoHandler.getTankIndex()) != -1) {
                PacketDropperUse.DropperAction action = button == 0 ? (Screen.hasShiftDown() ? PacketDropperUse.DropperAction.DUMP_TANK : PacketDropperUse.DropperAction.FILL_DROPPER) : PacketDropperUse.DropperAction.DRAIN_DROPPER;
                PacketUtils.sendToServer((CustomPacketPayload)new PacketDropperUse(gui.getTileEntity().getBlockPos(), action, this.tankType, index));
            }
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    public static interface ITankInfoHandler<TANK> {
        @Nullable
        public TANK getTank();

        public int getTankIndex();
    }
}

