/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes;

import com.jerry.mekmm.api.recipes.MoreMachineRecipeTypes;
import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class StamperRecipe
extends MekanismRecipe<RecipeInput>
implements BiPredicate<ItemStack, ItemStack> {
    private static final Holder<Item> STAMPER = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekmm", (String)"stamper"));

    @Override
    public abstract boolean test(ItemStack var1, ItemStack var2);

    public abstract ItemStackIngredient getMainInput();

    public abstract ItemStackIngredient getExtraInput();

    @NotNull
    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        ItemStack extraInput;
        ItemStack mainInput;
        if (!this.isIncomplete() && input.size() == 2 && this.test(mainInput = input.getItem(0), extraInput = input.getItem(1))) {
            return this.getOutput(mainInput, extraInput);
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(RecipeInput input, Level level) {
        return !this.isIncomplete() && input.size() == 2 && this.test(input.getItem(0), input.getItem(1));
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 1;
    }

    @Contract(value="_, _ -> new", pure=true)
    public abstract ItemStack getOutput(@NotNull ItemStack var1, @NotNull ItemStack var2);

    @NotNull
    public abstract ItemStack getResultItem(@NotNull HolderLookup.Provider var1);

    public abstract List<ItemStack> getOutputDefinition();

    public boolean isIncomplete() {
        return this.getMainInput().hasNoMatchingInstances() || this.getExtraInput().hasNoMatchingInstances();
    }

    public final RecipeType<StamperRecipe> getType() {
        return (RecipeType)MoreMachineRecipeTypes.TYPE_STAMPING.value();
    }

    public String getGroup() {
        return "stamper";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(STAMPER);
    }
}

