/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;

public class RedstoneModeButton
extends Button {
    private final RedstoneMode mode;
    private final Supplier<RedstoneMode> getter;
    private final BiConsumer<RedstoneMode, Boolean> setter;
    private Rect2i scissorRect;

    public RedstoneModeButton(RedstoneMode mode, Supplier<RedstoneMode> getter, BiConsumer<RedstoneMode, Boolean> setter) {
        super(0, 0, 16, 16, mode.getTranslation(), button -> {}, DEFAULT_NARRATION);
        this.mode = mode;
        this.getter = getter;
        this.setter = setter;
    }

    public void onPress() {
        this.setter.accept(this.mode, true);
    }

    public void setScissorRect(Rect2i scissorRect) {
        this.scissorRect = scissorRect;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scissorRect == null) {
            return;
        }
        RenderSystem.enableScissor((int)this.scissorRect.getX(), (int)this.scissorRect.getY(), (int)this.scissorRect.getWidth(), (int)this.scissorRect.getHeight());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int x = 176;
        if (!this.isActive()) {
            x += 16;
        } else if (this.getter.get() == this.mode) {
            x += 32;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blit(ItemAttachedIoScreen.TEXTURE, this.getX(), this.getY(), x, 180, this.width, this.height);
        int iconX = 240;
        int iconY = switch (this.mode) {
            default -> throw new MatchException(null, null);
            case RedstoneMode.IGNORED -> 208;
            case RedstoneMode.REQUIRES_LOW -> 240;
            case RedstoneMode.REQUIRES_HIGH -> 224;
        };
        guiGraphics.blit(ItemAttachedIoScreen.TEXTURE, this.getX(), this.getY(), iconX, iconY, 16, 16);
        RenderSystem.disableScissor();
        if (this.isHovered) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getMessage(), mouseX, mouseY);
        }
    }
}

