/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.jei;

import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.client.compat.jei.UpgradeDisplay;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeCategory
implements IRecipeCategory<UpgradeDisplay> {
    public static final RecipeType<UpgradeDisplay> TYPE = RecipeType.create((String)"moderndynamics", (String)"upgrades", UpgradeDisplay.class);
    public static final int EFFECT_WIDTH = 23;
    public static final int EFFECT_SPACING = 5;
    public static final int EFFECT_BASE_Y = 37;
    public static final ResourceLocation ICON_TEXTURE = MdId.of("textures/gui/icons.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable slotDrawable;
    private final IDrawable[] icons;

    public UpgradeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 59);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MdItems.EXTRACTOR));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.icons = new IDrawable[]{guiHelper.createDrawable(ICON_TEXTURE, 0, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 16, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 32, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 48, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 64, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 80, 0, 16, 16), guiHelper.createDrawable(ICON_TEXTURE, 96, 0, 16, 16)};
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.moderndynamics.rei.upgrade_category");
    }

    public RecipeType<UpgradeDisplay> getRecipeType() {
        return TYPE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, UpgradeDisplay recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addItemStack(new ItemStack((ItemLike)recipe.item()));
    }

    private EffectsInfo computeEffects(UpgradeDisplay recipe) {
        UpgradeType type = recipe.upgradeInfo();
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", I18n.get((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(1, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(2, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(3, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(4, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(5, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(6, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        int totalWidth = effects.size() * 23 + (effects.size() - 1) * 5;
        int effectsBaseX = (this.background.getWidth() - totalWidth) / 2;
        return new EffectsInfo(effects, effectsBaseX);
    }

    public void draw(UpgradeDisplay recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.slotDrawable.draw(guiGraphics, 2, 2);
        UpgradeType type = recipe.upgradeInfo();
        int countXOffset = 17;
        int countY = 50;
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MutableComponent maxUpgrades = Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()});
        guiGraphics.drawString(font, (Component)maxUpgrades, 25, 7, -12566464, false);
        MutableComponent effectsText = Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_effects").withStyle(ChatFormatting.UNDERLINE);
        int effectsTextX = (this.background.getWidth() - font.width((FormattedText)effectsText)) / 2;
        guiGraphics.drawString(font, (Component)effectsText, effectsTextX, 23, -12566464, false);
        EffectsInfo effects = this.computeEffects(recipe);
        int baseX = effects.effectsBaseX();
        for (UpgradeEffect e : effects.effects()) {
            this.icons[e.iconIndex].draw(guiGraphics, baseX, 37);
            if (e.count >= 0) {
                guiGraphics.drawString(font, String.valueOf(e.count), baseX + countXOffset, countY, -12566464, false);
            }
            baseX += 28;
        }
    }

    public List<Component> getTooltipStrings(UpgradeDisplay recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        EffectsInfo effects = this.computeEffects(recipe);
        int x = effects.effectsBaseX();
        for (UpgradeEffect e : effects.effects()) {
            Rect2i tooltipRect = new Rect2i(x, 37, 20, 20);
            if (tooltipRect.contains((int)mouseX, (int)mouseY)) {
                Style greenStyle = Style.EMPTY.applyFormat(ChatFormatting.GREEN);
                MutableComponent tooltip = Component.translatable((String)("gui.moderndynamics.tooltip.upgrade_" + e.upgradeName()), (Object[])new Object[]{Component.literal((String)e.greenText).setStyle(greenStyle)});
                return List.of(tooltip);
            }
            x += 28;
        }
        return List.of();
    }

    private record UpgradeEffect(int iconIndex, int count, String upgradeName, String greenText) {
    }

    private record EffectsInfo(List<UpgradeEffect> effects, int effectsBaseX) {
    }
}

