/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.upgrade;

import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.packets.SetAttachmentUpgrades;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class LoadedUpgrades {
    private static LoadedUpgrades holder = new LoadedUpgrades(Map.of(), List.of());
    private static final UpgradeType DUMMY_UPGRADE = UpgradeType.createDummy();
    public static final StreamCodec<FriendlyByteBuf, LoadedUpgrades> STREAM_CODEC = StreamCodec.ofMember(LoadedUpgrades::toPacket, LoadedUpgrades::fromPacket);
    public final Map<Item, UpgradeType> map;
    public final List<Item> list;

    public static LoadedUpgrades get() {
        return holder;
    }

    public static UpgradeType getType(Item item) {
        return LoadedUpgrades.holder.map.getOrDefault(item, DUMMY_UPGRADE);
    }

    public static void trySet(@Nullable LoadedUpgrades upgrades) {
        if (upgrades != null) {
            holder = upgrades;
        }
    }

    public static void syncToClient(ServerPlayer player) {
        player.connection.send((CustomPacketPayload)new SetAttachmentUpgrades(holder));
    }

    public static void syncToAllClients(PlayerList playerList) {
        playerList.broadcastAll((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SetAttachmentUpgrades(holder)));
    }

    public LoadedUpgrades(Map<Item, UpgradeType> map, List<Item> list) {
        this.map = Collections.unmodifiableMap(map);
        this.list = Collections.unmodifiableList(list);
    }

    private void toPacket(FriendlyByteBuf buf) {
        buf.writeVarInt(this.list.size());
        for (Item upgradeItem : this.list) {
            buf.writeVarInt(Item.getId((Item)upgradeItem));
            this.map.get(upgradeItem).writePacket(buf);
        }
    }

    private static LoadedUpgrades fromPacket(FriendlyByteBuf buf) {
        int count = buf.readVarInt();
        IdentityHashMap<Item, UpgradeType> upgrades = new IdentityHashMap<Item, UpgradeType>();
        ArrayList<Item> orderedUpgrades = new ArrayList<Item>();
        for (int i = 0; i < count; ++i) {
            Item item = Item.byId((int)buf.readVarInt());
            upgrades.put(item, UpgradeType.readPacket(buf));
            orderedUpgrades.add(item);
        }
        return new LoadedUpgrades(upgrades, orderedUpgrades);
    }
}

