/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.impl.misc.LeaderboardCommand;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;

public class Leaderboard<N extends Number> {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final Map<String, Leaderboard<?>> MAP = new LinkedHashMap();
    private final String name;
    private final N defaultValue;
    private Function<ServerStatsCounter, N> valueGetter;
    private Predicate<N> filter;
    private Function<N, String> stringGetter;

    public static <T extends Number> Leaderboard<T> add(String name, T defaultValue) {
        Leaderboard<T> leaderboard = new Leaderboard<T>(name, defaultValue);
        MAP.put(name, leaderboard);
        return leaderboard;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> buildCommand() {
        LiteralArgumentBuilder res = Commands.literal((String)"leaderboard");
        for (Leaderboard<?> leaderboard : MAP.values()) {
            res = (LiteralArgumentBuilder)res.then(Commands.literal((String)leaderboard.name).executes(context -> LeaderboardCommand.leaderboard((CommandSourceStack)context.getSource(), leaderboard, false)));
        }
        return res;
    }

    public Leaderboard(String name, N defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.valueGetter = stats -> this.defaultValue;
        this.filter = num -> !num.equals(this.defaultValue);
        this.stringGetter = num -> NumberFormat.getIntegerInstance(Locale.US).format(num.intValue());
    }

    public String getName() {
        return this.name;
    }

    public String formattedName() {
        String[] parts = this.name.split("_");
        return Stream.of(parts).map(s -> Character.toTitleCase(s.charAt(0)) + s.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public Leaderboard<N> withValueGetter(Function<ServerStatsCounter, N> v) {
        this.valueGetter = v;
        return this;
    }

    public Leaderboard<N> withFilter(Predicate<N> f) {
        this.filter = f;
        return this;
    }

    public Leaderboard<N> withStringGetter(Function<N, String> s) {
        this.stringGetter = s;
        return this;
    }

    public N getValue(ServerStatsCounter stats) {
        return (N)((Number)this.valueGetter.apply(stats));
    }

    public boolean test(N num) {
        return this.filter.test(num);
    }

    public String asString(N num) {
        return this.stringGetter.apply(num);
    }

    public Leaderboard<N> formatDivideByTen() {
        return this.withStringGetter(value -> DECIMAL_FORMAT.format(value.doubleValue() * 0.1));
    }

    public Leaderboard<N> formatDistance() {
        return this.withStringGetter(value -> {
            double d0 = value.doubleValue() / 100.0;
            double d1 = d0 / 1000.0;
            if (d1 > 0.5) {
                return DECIMAL_FORMAT.format(d1) + " km";
            }
            return d0 > 0.5 ? DECIMAL_FORMAT.format(d0) + " m" : String.valueOf(value) + " cm";
        });
    }

    public Leaderboard<N> formatTime() {
        return this.withStringGetter(value -> {
            double d0 = value.doubleValue() / 20.0;
            double d1 = d0 / 60.0;
            double d2 = d1 / 60.0;
            double d3 = d2 / 24.0;
            double d4 = d3 / 365.0;
            if (d4 > 0.5) {
                return DECIMAL_FORMAT.format(d4) + " y";
            }
            if (d3 > 0.5) {
                return DECIMAL_FORMAT.format(d3) + " d";
            }
            if (d2 > 0.5) {
                return DECIMAL_FORMAT.format(d2) + " h";
            }
            return d1 > 0.5 ? DECIMAL_FORMAT.format(d1) + " m" : d0 + " s";
        });
    }

    static {
        Leaderboard.add("deaths", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.DEATHS)));
        Leaderboard.add("time_played", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME))).formatTime();
        Leaderboard.add("deaths_per_hour", 0.0).withValueGetter(stats -> {
            int d = stats.getValue(Stats.CUSTOM.get((Object)Stats.DEATHS));
            int t = stats.getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
            return d <= 0 || t < 72000 ? 0.0 : (double)d * 72000.0 / (double)t;
        }).withStringGetter(value -> DECIMAL_FORMAT.format((double)value));
        Leaderboard.add("player_kills", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.PLAYER_KILLS)));
        Leaderboard.add("mob_kills", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.MOB_KILLS)));
        Leaderboard.add("damage_dealt", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.DAMAGE_DEALT))).formatDivideByTen();
        Leaderboard.add("jumps", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.JUMP)));
        Leaderboard.add("distance_walked", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.WALK_ONE_CM))).formatDistance();
        Leaderboard.add("time_since_death", 0).withValueGetter(stats -> stats.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH))).formatTime();
    }
}

