/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.polyglot;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Engine;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.ResourceLimitEvent;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Source;

public final class ResourceLimits {
    private static final ResourceLimits EMPTY = new ResourceLimits(null);
    final Object receiver;

    ResourceLimits(Object receiver) {
        this.receiver = receiver;
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    public final class Builder {
        long statementLimit;
        Predicate<?> statementLimitSourceFilter;
        Consumer<?> onLimit;

        Builder() {
        }

        public Builder statementLimit(long limit, Predicate<Source> sourceFilter) {
            if (limit < 0L) {
                throw new IllegalArgumentException("The statement limit must not be negative.");
            }
            this.statementLimit = limit;
            this.statementLimitSourceFilter = sourceFilter;
            return this;
        }

        public Builder onLimit(Consumer<ResourceLimitEvent> onLimit) {
            this.onLimit = onLimit;
            return this;
        }

        public ResourceLimits build() {
            return new ResourceLimits(Engine.getImpl().buildLimits(this.statementLimit, this.statementLimitSourceFilter, this.onLimit));
        }
    }
}

