/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeReader;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.io.Reader;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;

final class NativeReaderGen {
    NativeReaderGen() {
    }

    static NativeReader createHSToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeReader createNativeToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeReader create(NativeObject nativeObject) {
        if (ImageInfo.inImageCode()) {
            return NativeReaderGen.createNativeToNative(nativeObject);
        }
        return NativeReaderGen.createHSToNative(nativeObject);
    }

    private static final class StartPoint
    extends NativeReader {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeObject nativeObject) {
            super(nativeObject);
        }

        @Override
        public void close() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                StartPoint.close0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void mark(int n2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                StartPoint.mark0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle(), n2);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean markSupported() {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                boolean bl = StartPoint.markSupported0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int read() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                int n2 = StartPoint.read0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle());
                return n2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                int n4 = StartPoint.read0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle(), cArray, n2, n3);
                return n4;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean ready() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                boolean bl = StartPoint.ready0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void reset() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                StartPoint.reset0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateReader.getIsolate().enter();
            try {
                long l3 = StartPoint.skip0(nativeIsolateThread.getIsolateThreadId(), this.isolateReader.getHandle(), l2);
                return l3;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void close0(long var0, long var2) throws IOException;

        private static native void mark0(long var0, long var2, int var4) throws IOException;

        private static native boolean markSupported0(long var0, long var2);

        private static native int read0(long var0, long var2) throws IOException;

        private static native int read0(long var0, long var2, char[] var4, int var5, int var6) throws IOException;

        private static native boolean ready0(long var0, long var2) throws IOException;

        private static native void reset0(long var0, long var2) throws IOException;

        private static native long skip0(long var0, long var2, long var4) throws IOException;

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_close0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void close(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::close", jNIEnv);){
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                reader.close();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_mark0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void mark(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, int n2) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::mark", jNIEnv);){
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                reader.mark(n2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_markSupported0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean markSupported(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::markSupported", jNIEnv);
            try {
                boolean bl;
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                boolean bl2 = bl = reader.markSupported();
                jNIMethodScope.close();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_read0__JJ", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int read(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::read", jNIEnv);
            try {
                int n2;
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                int n3 = n2 = reader.read();
                jNIMethodScope.close();
                return n3;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_read0__JJ_3CII", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int read(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JCharArray jCharArray, int n2, int n3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::read", jNIEnv);
            try {
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                char[] cArray = new char[n3];
                int n4 = reader.read(cArray, 0, n3);
                if (n4 > 0) {
                    JNIUtil.arrayCopy(jNIEnv, cArray, 0, jCharArray, n2, n4);
                }
                int n5 = n4;
                jNIMethodScope.close();
                return n5;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_ready0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean ready(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::ready", jNIEnv);
            try {
                boolean bl;
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                boolean bl2 = bl = reader.ready();
                jNIMethodScope.close();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_reset0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void reset(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::reset", jNIEnv);){
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                reader.reset();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeReaderGen_00024StartPoint_skip0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long skip(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeReaderGen::skip", jNIEnv);
            try {
                long l5;
                Reader reader = NativeObjectHandles.resolve(l3, Reader.class);
                long l6 = l5 = reader.skip(l4);
                jNIMethodScope.close();
                return l6;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0L;
                }
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

