/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSPath;
import com.oracle.truffle.polyglot.enterprise.HSPathIteratorGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.HSObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

final class HSPathGen {
    HSPathGen() {
    }

    static HSPath createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSPath {
        private static final String PATH_BINARY_NAME = "java/nio/file/Path";
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<String> stringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public int compareTo(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.compareToMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean endsWith(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.endsWithMethod2, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean endsWith(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.endsWithMethod3, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        boolean equalsImpl(Object object) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(object != null ? ((HSObject)object).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.equalsImplMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path getFileName() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getFileNameMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path getName(int n2) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setInt(n2);
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getNameMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public int getNameCount() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getNameCountMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path getParent() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getParentMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path getRoot() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getRootMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        int hashCodeImpl() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.hashCodeImplMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isAbsolute() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isAbsoluteMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Iterator<Path> iterator() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.iteratorMethod, jValue);
                return r2.isNonNull() ? HSPathIteratorGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path normalize() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.normalizeMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path relativize(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.relativizeMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path resolve(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveMethod2, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path resolve(String string, String ... stringArray) {
            HSPath hSPath;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (stringArray != null && stringArray.length > 0 ? stringArray.length * stringMarshaller.inferSize(stringArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (stringArray != null) {
                            ((BinaryOutput)object).writeInt(stringArray.length);
                            for (String string2 : stringArray) {
                                stringMarshaller.write((BinaryOutput)object, string2);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                    object.addressOf(2).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveMethod3, (JNI.JValue)object);
                    HSPath hSPath2 = hSPath = r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSPath;
        }

        @Override
        public Path resolve(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveMethod4, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public Path resolve(Path path, Path ... pathArray) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JObjectArray jObjectArray = JNIUtil.createHSArray(jNIEnv, pathArray, 0, pathArray.length, PATH_BINARY_NAME);
                JNI.JValue jValue = StackValue.get(3, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                jValue.addressOf(2).setJObject(jObjectArray);
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveMethod5, jValue);
                HSPath hSPath = r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
                return hSPath;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path resolveSibling(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveSiblingMethod2, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path resolveSibling(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.resolveSiblingMethod3, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean startsWith(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.startsWithMethod2, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean startsWith(Path path) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(path != null ? ((HSObject)((Object)path)).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.startsWithMethod3, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path subpath(int n2, int n3) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(3, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setInt(n2);
                jValue.addressOf(2).setInt(n3);
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.subpathMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Path toAbsolutePath() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toAbsolutePathMethod, jValue);
                return r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Path toRealPath(LinkOption ... linkOptionArray) throws IOException {
            HSPath hSPath;
            block18: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = 4 + (linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray.length * linkOptionMarshaller.inferSize(linkOptionArray[0]) : 0);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        if (linkOptionArray != null) {
                            ((BinaryOutput)object).writeInt(linkOptionArray.length);
                            for (LinkOption linkOption : linkOptionArray) {
                                linkOptionMarshaller.write((BinaryOutput)object, linkOption);
                            }
                        } else {
                            ((BinaryOutput)object).writeInt(-1);
                        }
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toRealPathMethod, (JNI.JValue)object);
                    HSPath hSPath2 = hSPath = r2.isNonNull() ? HSPathGen.createNativeToHS(jNIEnv, r2) : null;
                    if (cCharPointer == cCharPointer2) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return hSPath;
        }

        @Override
        public String toString() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return JNIUtil.createString(jNIEnv, (JNI.JString)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toStringMethod, jValue));
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URI toUri() {
            URI uRI;
            block6: {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                JNI.JByteArray jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toUriMethod, jValue);
                int n2 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n2);
                try {
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n2, cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n2);
                    uRI = uRIMarshaller.read(binaryInput);
                    if (cCharPointer2 == cCharPointer) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free(cCharPointer2);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer2);
            }
            return uRI;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            stringMarshaller = jNIConfig.lookupMarshaller(String.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod compareToMethod;
            final JNICalls.JNIMethod endsWithMethod2;
            final JNICalls.JNIMethod endsWithMethod3;
            final JNICalls.JNIMethod equalsImplMethod;
            final JNICalls.JNIMethod getFileNameMethod;
            final JNICalls.JNIMethod getNameMethod;
            final JNICalls.JNIMethod getNameCountMethod;
            final JNICalls.JNIMethod getParentMethod;
            final JNICalls.JNIMethod getRootMethod;
            final JNICalls.JNIMethod hashCodeImplMethod;
            final JNICalls.JNIMethod isAbsoluteMethod;
            final JNICalls.JNIMethod iteratorMethod;
            final JNICalls.JNIMethod normalizeMethod;
            final JNICalls.JNIMethod relativizeMethod;
            final JNICalls.JNIMethod resolveMethod2;
            final JNICalls.JNIMethod resolveMethod3;
            final JNICalls.JNIMethod resolveMethod4;
            final JNICalls.JNIMethod resolveMethod5;
            final JNICalls.JNIMethod resolveSiblingMethod2;
            final JNICalls.JNIMethod resolveSiblingMethod3;
            final JNICalls.JNIMethod startsWithMethod2;
            final JNICalls.JNIMethod startsWithMethod3;
            final JNICalls.JNIMethod subpathMethod;
            final JNICalls.JNIMethod toAbsolutePathMethod;
            final JNICalls.JNIMethod toRealPathMethod;
            final JNICalls.JNIMethod toStringMethod;
            final JNICalls.JNIMethod toUriMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.compareToMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "compareTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)I");
                this.endsWithMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "endsWith", "(Ljava/nio/file/Path;Ljava/lang/String;)Z");
                this.endsWithMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "endsWith", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Z");
                this.equalsImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "equalsImpl", "(Ljava/nio/file/Path;Ljava/lang/Object;)Z");
                this.getFileNameMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getFileName", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.getNameMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getName", "(Ljava/nio/file/Path;I)Ljava/nio/file/Path;");
                this.getNameCountMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getNameCount", "(Ljava/nio/file/Path;)I");
                this.getParentMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getParent", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.getRootMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getRoot", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.hashCodeImplMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "hashCodeImpl", "(Ljava/nio/file/Path;)I");
                this.isAbsoluteMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isAbsolute", "(Ljava/nio/file/Path;)Z");
                this.iteratorMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "iterator", "(Ljava/nio/file/Path;)Ljava/util/Iterator;");
                this.normalizeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "normalize", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.relativizeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "relativize", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.resolveMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolve", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/Path;");
                this.resolveMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolve", "(Ljava/nio/file/Path;Ljava/lang/String;[B)Ljava/nio/file/Path;");
                this.resolveMethod4 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolve", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.resolveMethod5 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolve", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.resolveSiblingMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolveSibling", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/Path;");
                this.resolveSiblingMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "resolveSibling", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.startsWithMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "startsWith", "(Ljava/nio/file/Path;Ljava/lang/String;)Z");
                this.startsWithMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "startsWith", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Z");
                this.subpathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "subpath", "(Ljava/nio/file/Path;II)Ljava/nio/file/Path;");
                this.toAbsolutePathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toAbsolutePath", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;");
                this.toRealPathMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toRealPath", "(Ljava/nio/file/Path;[B)Ljava/nio/file/Path;");
                this.toStringMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toString", "(Ljava/nio/file/Path;)Ljava/lang/String;");
                this.toUriMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toUri", "(Ljava/nio/file/Path;)[B");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<LinkOption> linkOptionMarshaller;
        private static final BinaryMarshaller<String> stringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<URI> uRIMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static int compareTo(Path path, Path path2) {
            try {
                int n2 = path.compareTo(path2);
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean endsWith(Path path, String string) {
            try {
                boolean bl = path.endsWith(string);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean endsWith(Path path, Path path2) {
            try {
                boolean bl = path.endsWith(path2);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean equalsImpl(Path path, Object object) {
            try {
                boolean bl = path.equals(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getFileName(Path path) {
            try {
                Path path2 = path.getFileName();
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getName(Path path, int n2) {
            try {
                Path path2 = path.getName(n2);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int getNameCount(Path path) {
            try {
                int n2 = path.getNameCount();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getParent(Path path) {
            try {
                Path path2 = path.getParent();
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path getRoot(Path path) {
            try {
                Path path2 = path.getRoot();
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int hashCodeImpl(Path path) {
            try {
                int n2 = path.hashCode();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isAbsolute(Path path) {
            try {
                boolean bl = path.isAbsolute();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Iterator<Path> iterator(Path path) {
            try {
                Iterator<Path> iterator = path.iterator();
                return iterator;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path normalize(Path path) {
            try {
                Path path2 = path.normalize();
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path relativize(Path path, Path path2) {
            try {
                Path path3 = path.relativize(path2);
                return path3;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolve(Path path, String string) {
            try {
                Path path2 = path.resolve(string);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolve(Path path, String string, byte[] byArray) {
            try {
                String[] stringArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    stringArray = new String[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string2;
                        stringArray[i2] = string2 = stringMarshaller.read(binaryInput);
                    }
                } else {
                    stringArray = null;
                }
                Path path2 = path.resolve(string, stringArray);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolve(Path path, Path path2) {
            try {
                Path path3 = path.resolve(path2);
                return path3;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolve(Path path, Path path2, Path[] pathArray) {
            try {
                Path path3 = path.resolve(path2, pathArray);
                return path3;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolveSibling(Path path, String string) {
            try {
                Path path2 = path.resolveSibling(string);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path resolveSibling(Path path, Path path2) {
            try {
                Path path3 = path.resolveSibling(path2);
                return path3;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean startsWith(Path path, String string) {
            try {
                boolean bl = path.startsWith(string);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean startsWith(Path path, Path path2) {
            try {
                boolean bl = path.startsWith(path2);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path subpath(Path path, int n2, int n3) {
            try {
                Path path2 = path.subpath(n2, n3);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toAbsolutePath(Path path) {
            try {
                Path path2 = path.toAbsolutePath();
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Path toRealPath(Path path, byte[] byArray) {
            try {
                LinkOption[] linkOptionArray;
                BinaryInput binaryInput = BinaryInput.create(byArray);
                int n2 = binaryInput.readInt();
                if (n2 != -1) {
                    linkOptionArray = new LinkOption[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        LinkOption linkOption;
                        linkOptionArray[i2] = linkOption = linkOptionMarshaller.read(binaryInput);
                    }
                } else {
                    linkOptionArray = null;
                }
                Path path2 = path.toRealPath(linkOptionArray);
                return path2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static String toString(Path path) {
            try {
                String string = path.toString();
                return string;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toUri(Path path) {
            try {
                URI uRI = path.toUri();
                int n2 = uRIMarshaller.inferSize(uRI);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create(n2);
                uRIMarshaller.write(byteArrayBinaryOutput, uRI);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            linkOptionMarshaller = jNIConfig.lookupMarshaller(LinkOption.class, new Class[0]);
            stringMarshaller = jNIConfig.lookupMarshaller(String.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            uRIMarshaller = jNIConfig.lookupMarshaller(URI.class, new Class[0]);
        }
    }
}

