/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSWebAssemblyValueTypes {
    public static final TruffleString I32 = Strings.I_32;
    public static final TruffleString I64 = Strings.I_64;
    public static final TruffleString F32 = Strings.F_32;
    public static final TruffleString F64 = Strings.F_64;
    public static final TruffleString V128 = Strings.V_128;
    public static final TruffleString ANYFUNC = Strings.ANYFUNC;
    public static final TruffleString EXTERNREF = Strings.EXTERNREF;

    public static boolean isI32(TruffleString type) {
        return Strings.equals(I32, type);
    }

    public static boolean isI64(TruffleString type) {
        return Strings.equals(I64, type);
    }

    public static boolean isF32(TruffleString type) {
        return Strings.equals(F32, type);
    }

    public static boolean isF64(TruffleString type) {
        return Strings.equals(F64, type);
    }

    public static boolean isV128(TruffleString type) {
        return Strings.equals(V128, type);
    }

    public static boolean isAnyfunc(TruffleString type) {
        return Strings.equals(ANYFUNC, type);
    }

    public static boolean isExternref(TruffleString type) {
        return Strings.equals(EXTERNREF, type);
    }

    public static boolean isValueType(TruffleString type) {
        return JSWebAssemblyValueTypes.isI32(type) || JSWebAssemblyValueTypes.isI64(type) || JSWebAssemblyValueTypes.isF32(type) || JSWebAssemblyValueTypes.isF64(type) || JSWebAssemblyValueTypes.isV128(type) || JSWebAssemblyValueTypes.isAnyfunc(type) || JSWebAssemblyValueTypes.isExternref(type);
    }

    public static boolean isReferenceType(TruffleString type) {
        return JSWebAssemblyValueTypes.isAnyfunc(type) || JSWebAssemblyValueTypes.isExternref(type);
    }

    public static Object getDefaultValue(JSRealm realm, TruffleString type) {
        if (JSWebAssemblyValueTypes.isI32(type)) {
            return 0;
        }
        if (JSWebAssemblyValueTypes.isI64(type)) {
            return 0L;
        }
        if (JSWebAssemblyValueTypes.isF32(type)) {
            return Float.valueOf(0.0f);
        }
        if (JSWebAssemblyValueTypes.isF64(type)) {
            return 0.0;
        }
        if (JSWebAssemblyValueTypes.isAnyfunc(type)) {
            return realm.getWasmRefNull();
        }
        if (JSWebAssemblyValueTypes.isExternref(type)) {
            return Undefined.instance;
        }
        throw Errors.shouldNotReachHere();
    }
}

