/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddZonedDateTimeNode
extends JavaScriptBaseNode {
    protected TemporalAddZonedDateTimeNode() {
    }

    public final BigInt execute(BigInt epochNanoseconds, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, double years, double months, double weeks, double days, BigInt norm, JSTemporalPlainDateTimeObject precalculatedPlainDateTime) {
        return this.execute(epochNanoseconds, timeZoneRec, calendarRec, years, months, weeks, days, norm, precalculatedPlainDateTime, Undefined.instance);
    }

    public abstract BigInt execute(BigInt var1, TimeZoneMethodsRecord var2, CalendarMethodsRecord var3, double var4, double var6, double var8, double var10, BigInt var12, JSTemporalPlainDateTimeObject var13, JSDynamicObject var14);

    @Specialization
    protected BigInt addZonedDateTime(BigInt epochNanoseconds, TimeZoneMethodsRecord timeZoneRec, CalendarMethodsRecord calendarRec, double years, double months, double weeks, double days, BigInt norm, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, JSDynamicObject options, @Cached ToTemporalCalendarObjectNode toCalendarObject, @Cached(value="createCall()") JSFunctionCallNode callDateAddNode, @Cached InlinedBranchProfile errorBranch) {
        JSTemporalPlainDateTimeObject temporalDateTime;
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        if (years == 0.0 && months == 0.0 && weeks == 0.0 && days == 0.0) {
            return TemporalUtil.addInstant(epochNanoseconds, norm);
        }
        JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, epochNanoseconds);
        JSTemporalPlainDateTimeObject jSTemporalPlainDateTimeObject = temporalDateTime = precalculatedPlainDateTime != null ? precalculatedPlainDateTime : TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZoneRec, instant, calendarRec.receiver());
        if (years == 0.0 && months == 0.0 && weeks == 0.0) {
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options);
            BigInt intermediate = TemporalUtil.addDaysToZonedDateTime(ctx, realm, instant, temporalDateTime, timeZoneRec, (int)days, overflow).epochNanoseconds();
            return TemporalUtil.addInstant(intermediate, norm);
        }
        JSTemporalPlainDateObject datePart = JSTemporalPlainDate.create(ctx, realm, temporalDateTime.getYear(), temporalDateTime.getMonth(), temporalDateTime.getDay(), calendarRec.receiver(), this, errorBranch);
        JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject addedDate = TemporalUtil.calendarDateAdd(calendarRec, datePart, dateDuration, options, toCalendarObject, callDateAddNode);
        JSTemporalPlainDateTimeObject intermediateDateTime = JSTemporalPlainDateTime.create(ctx, realm, addedDate.getYear(), addedDate.getMonth(), addedDate.getDay(), temporalDateTime.getHour(), temporalDateTime.getMinute(), temporalDateTime.getSecond(), temporalDateTime.getMillisecond(), temporalDateTime.getMicrosecond(), temporalDateTime.getNanosecond(), calendarRec.receiver());
        JSTemporalInstantObject intermediateInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, intermediateDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        return TemporalUtil.addInstant(intermediateInstant.getNanoseconds(), norm);
    }
}

