/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSMultiplyNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Set;

@NodeInfo(shortName="*")
public abstract class JSMultiplyNode
extends JSBinaryNode {
    protected JSMultiplyNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        if (left instanceof JSConstantNode.JSConstantIntegerNode && right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue;
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            long result = (long)leftValue * (long)(rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null));
            if (result == 0L && (leftValue < 0 || rightValue < 0)) {
                return JSConstantNode.createDouble(-0.0);
            }
            if (JSRuntime.longIsRepresentableAsInt(result)) {
                return JSConstantNode.createInt((int)result);
            }
            return JSConstantNode.createDouble(result);
        }
        return JSMultiplyNodeGen.create(left, right);
    }

    public static JSMultiplyNode create() {
        return (JSMultiplyNode)JSMultiplyNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization(guards={"b > 0"}, rewriteOn={ArithmeticException.class})
    protected int doIntBLargerZero(int a2, int b2) {
        return Math.multiplyExact(a2, b2);
    }

    @Specialization(guards={"a > 0"}, rewriteOn={ArithmeticException.class})
    protected int doIntALargerZero(int a2, int b2) {
        return Math.multiplyExact(a2, b2);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected int doInt(int a2, int b2, @Cached @Cached.Exclusive InlinedBranchProfile resultZeroBranch) {
        int result = Math.multiplyExact(a2, b2);
        if (result == 0) {
            resultZeroBranch.enter(this);
            if (a2 < 0 || b2 < 0) {
                throw new ArithmeticException("could be -0");
            }
        }
        return result;
    }

    @Specialization
    protected double doDouble(double a2, double b2) {
        return a2 * b2;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected BigInt doBigInts(BigInt a2, BigInt b2) {
        try {
            return a2.multiply(b2);
        }
        catch (ArithmeticException ae) {
            throw Errors.createRangeErrorBigIntMaxSizeExceeded();
        }
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_STAR;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doDouble"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached JSMultiplyNode nestedMultiplyNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached @Cached.Exclusive InlinedBranchProfile mixedNumericTypes) {
        Object operandA = toNumeric1Node.execute(a2);
        Object operandB = toNumeric2Node.execute(b2);
        JSMultiplyNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return nestedMultiplyNode.execute(operandA, operandB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSMultiplyNodeGen.create(JSMultiplyNode.cloneUninitialized(this.getLeft(), materializedTags), JSMultiplyNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

