/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.json;

import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.builtins.json.JSONParseRecord;
import com.oracle.truffle.js.builtins.json.NashornJSONParser;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ParserException;

public final class TruffleJSONParser {
    protected final Mode mode;
    protected final boolean withSource;
    protected final JSContext context;
    protected int pos;
    protected int len;
    protected TruffleString parseStr;
    protected int parseDepth;
    protected static final int MAX_PARSE_DEPTH = 100000;
    private static final String MALFORMED_NUMBER = "malformed number";

    public TruffleJSONParser(JSContext context) {
        this(context, Mode.WithoutReviver);
    }

    public TruffleJSONParser(JSContext context, Mode mode) {
        this.context = context;
        this.mode = mode;
        this.withSource = mode == Mode.WithReviverAndSource;
    }

    public Object parse(TruffleString value, JSRealm realm) {
        this.pos = 0;
        this.parseDepth = 0;
        this.parseStr = value;
        this.len = Strings.length(this.parseStr);
        try {
            if (this.mode != Mode.RawJSON) {
                this.skipWhitespace();
            } else if (TruffleJSONParser.isObjectOrArrayStart(this.get())) {
                throw this.unexpectedToken();
            }
            Object result = this.parseJSONValue(realm);
            if (this.mode != Mode.RawJSON) {
                this.skipWhitespace();
            }
            if (this.posValid()) {
                throw this.error("JSON cannot be fully parsed");
            }
            Object object = result;
            return object;
        }
        catch (StackOverflowError ex) {
            throw TruffleJSONParser.stackOverflowError();
        }
        catch (JSException ex) {
            throw ex;
        }
        catch (IndexOutOfBoundsException ex) {
            throw TruffleJSONParser.syntaxError(this.unexpectedEndOfInputMessage());
        }
        catch (Exception ex) {
            throw TruffleJSONParser.syntaxError(null);
        }
        finally {
            this.parseStr = null;
        }
    }

    private String unexpectedEndOfInputMessage() {
        return this.context.isOptionNashornCompatibilityMode() ? "Unexpected end of input" : "Unexpected end of JSON input";
    }

    protected Object parseJSONValue(JSRealm realm) {
        char c2 = this.get();
        if (TruffleJSONParser.isStringQuote(c2)) {
            return this.parseJSONString();
        }
        if (TruffleJSONParser.isObjectStart(c2)) {
            return this.parseJSONObject(realm);
        }
        if (TruffleJSONParser.isArrayStart(c2)) {
            return this.parseJSONArray(realm);
        }
        if (this.isNullLiteral(c2)) {
            return this.parseNullLiteral();
        }
        if (this.isBooleanLiteral(c2)) {
            return this.parseBooleanLiteral();
        }
        if (TruffleJSONParser.isNumber(c2)) {
            return this.parseJSONNumber();
        }
        throw this.unexpectedToken();
    }

    protected static boolean isNumber(char cur) {
        return cur == '-' || JSRuntime.isAsciiDigit(cur);
    }

    protected static boolean isObjectStart(char c2) {
        return c2 == '{';
    }

    protected static boolean isArrayStart(char c2) {
        return c2 == '[';
    }

    protected static boolean isObjectOrArrayStart(char c2) {
        return TruffleJSONParser.isObjectStart(c2) || TruffleJSONParser.isArrayStart(c2);
    }

    private Object parseJSONObject(JSRealm realm) {
        assert (TruffleJSONParser.isObjectStart(this.get()));
        this.incDepth();
        this.skipChar('{');
        this.skipWhitespace();
        JSObject object = JSOrdinary.create(this.context, realm);
        JSONParseRecord parseRecord = null;
        if (this.withSource) {
            parseRecord = JSONParseRecord.forObject(object);
        }
        if (this.get() != '}') {
            this.parseJSONMemberList(object, realm, parseRecord);
            if (this.get() != '}') {
                if (this.get() == '\"') {
                    throw this.unexpectedString();
                }
                throw this.unexpectedToken();
            }
        }
        this.skipWhitespace();
        this.skipChar('}');
        this.decDepth();
        if (this.withSource) {
            return parseRecord;
        }
        return object;
    }

    private void parseJSONMemberList(JSObject object, JSRealm realm, JSONParseRecord parseRecord) {
        while (true) {
            this.parseJSONMember(object, realm, parseRecord);
            this.skipWhitespace();
            if (this.get() != ',') break;
            this.skipChar(',');
            this.skipWhitespace();
        }
    }

    private void parseJSONMember(JSObject object, JSRealm realm, JSONParseRecord parseRecord) {
        TruffleString jsonKey = this.getJSONString();
        this.skipWhitespace();
        if (this.get(this.pos) != ':') {
            throw this.error("Expected ':' after property name in JSON");
        }
        this.skipChar(':');
        this.skipWhitespace();
        Object jsonValue = this.parseJSONValue(realm);
        if (this.withSource) {
            JSONParseRecord entryRecord = (JSONParseRecord)jsonValue;
            jsonValue = entryRecord.value();
            parseRecord.entries().put(jsonKey, entryRecord);
        }
        JSRuntime.createDataProperty(object, jsonKey, jsonValue);
    }

    private Object parseJSONArray(JSRealm realm) {
        assert (TruffleJSONParser.isArrayStart(this.get()));
        this.incDepth();
        this.skipChar('[');
        this.skipWhitespace();
        JSArrayObject array = JSArray.createEmptyZeroLength(this.context, realm);
        JSONParseRecord parseRecord = null;
        if (this.withSource) {
            parseRecord = JSONParseRecord.forArray(array);
        }
        if (this.get() != ']') {
            this.parseJSONElementList(array, realm, parseRecord);
            if (this.get() != ']') {
                throw this.error("closing quote ] expected");
            }
        }
        this.skipWhitespace();
        this.skipChar(']');
        this.decDepth();
        if (this.withSource) {
            return parseRecord;
        }
        return array;
    }

    private void incDepth() {
        ++this.parseDepth;
        if (this.parseDepth > 100000) {
            throw TruffleJSONParser.stackOverflowError();
        }
    }

    protected static RuntimeException stackOverflowError() {
        throw Errors.createRangeError("Cannot parse JSON constructs nested that deep");
    }

    protected static RuntimeException syntaxError(String msg) {
        throw Errors.createSyntaxError(msg == null ? "Cannot parse JSON" : msg);
    }

    protected void decDepth() {
        --this.parseDepth;
    }

    protected void parseJSONElementList(JSArrayObject arrayObject, JSRealm realm, JSONParseRecord parseRecord) {
        int index = 0;
        ScriptArray scriptArray = JSAbstractArray.arrayGetArrayType(arrayObject);
        while (true) {
            Object jsonValue = this.parseJSONValue(realm);
            if (this.withSource) {
                JSONParseRecord elementRecord = (JSONParseRecord)jsonValue;
                jsonValue = elementRecord.value();
                assert (parseRecord.elements().size() == index);
                parseRecord.elements().add(elementRecord);
            }
            scriptArray = scriptArray.setElement(arrayObject, index, jsonValue, false);
            this.skipWhitespace();
            if (this.get() != ',') break;
            this.skipChar(',');
            this.skipWhitespace();
            ++index;
        }
        JSAbstractArray.arraySetArrayType(arrayObject, scriptArray);
    }

    protected Object parseJSONString() {
        int startPos = this.pos;
        TruffleString parsedString = this.getJSONString();
        if (this.withSource) {
            return this.parseRecordForLiteral(parsedString, startPos);
        }
        return parsedString;
    }

    protected TruffleString getJSONString() {
        if (!TruffleJSONParser.isStringQuote(this.get())) {
            if (TruffleJSONParser.isDigit(this.get())) {
                throw this.unexpectedNumber();
            }
            throw this.unexpectedToken();
        }
        this.skipChar('\"');
        TruffleString str = this.parseJSONStringCharacters();
        if (!TruffleJSONParser.isStringQuote(this.get())) {
            throw this.error("String quote expected");
        }
        this.skipChar('\"');
        return str;
    }

    protected static boolean isStringQuote(char c2) {
        return c2 == '\"';
    }

    protected static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    protected TruffleString parseJSONStringCharacters() {
        int startPos = this.pos;
        boolean hasEscapes = false;
        int firstEscape = -1;
        char c2 = this.get();
        while (!TruffleJSONParser.isStringQuote(c2)) {
            if (c2 < ' ') {
                throw this.error("invalid string");
            }
            if (c2 == '\\') {
                if (!hasEscapes) {
                    firstEscape = this.pos;
                }
                hasEscapes = true;
                this.skipChar('\\');
                ++this.pos;
            } else {
                this.skipChar();
            }
            c2 = this.get();
        }
        int sLength = this.pos - startPos;
        TruffleString s2 = Strings.lazySubstring(this.parseStr, startPos, sLength);
        if (hasEscapes) {
            return this.unquoteJSON(s2, sLength, firstEscape - startPos);
        }
        return s2;
    }

    protected TruffleString unquoteJSON(TruffleString string, int sLength, int posFirstBackslash) {
        assert (sLength == Strings.length(string));
        assert (posFirstBackslash >= 0);
        int posBackslash = posFirstBackslash;
        int curPos = 0;
        TruffleStringBuilderUTF16 builder = Strings.builderCreate(sLength);
        while (posBackslash >= 0) {
            Strings.builderAppend(builder, string, curPos, posBackslash);
            curPos = posBackslash;
            char c2 = Strings.charAt(string, posBackslash + 1);
            switch (c2) {
                case '\"': {
                    Strings.builderAppend(builder, '\"');
                    break;
                }
                case '\\': {
                    Strings.builderAppend(builder, '\\');
                    break;
                }
                case 'b': {
                    Strings.builderAppend(builder, '\b');
                    break;
                }
                case 'f': {
                    Strings.builderAppend(builder, '\f');
                    break;
                }
                case 'n': {
                    Strings.builderAppend(builder, '\n');
                    break;
                }
                case 'r': {
                    Strings.builderAppend(builder, '\r');
                    break;
                }
                case 't': {
                    Strings.builderAppend(builder, '\t');
                    break;
                }
                case '/': {
                    Strings.builderAppend(builder, '/');
                    break;
                }
                case 'u': {
                    this.unquoteJSONUnicode(string, posBackslash, builder);
                    curPos += 4;
                    break;
                }
                default: {
                    throw this.error("wrong escape sequence");
                }
            }
            posBackslash = Strings.indexOf(string, 92, curPos += 2);
        }
        if (curPos < sLength) {
            Strings.builderAppend(builder, string, curPos, sLength);
        }
        return Strings.builderToString(builder);
    }

    protected int hexDigitValue(char c2) {
        int value = JSRuntime.valueInHex(c2);
        if (value < 0) {
            throw this.error("invalid string");
        }
        return value;
    }

    protected void unquoteJSONUnicode(TruffleString string, int posBackslash, TruffleStringBuilderUTF16 builder) {
        char c1 = Strings.charAt(string, posBackslash + 2);
        char c2 = Strings.charAt(string, posBackslash + 3);
        char c3 = Strings.charAt(string, posBackslash + 4);
        char c4 = Strings.charAt(string, posBackslash + 5);
        char unencodedC = (char)(this.hexDigitValue(c1) << 12 | this.hexDigitValue(c2) << 8 | this.hexDigitValue(c3) << 4 | this.hexDigitValue(c4));
        Strings.builderAppend(builder, unencodedC);
    }

    protected Object parseJSONNumber() {
        int startPos = this.pos;
        Number parsedNumber = this.getJSONNumber();
        if (this.withSource) {
            return this.parseRecordForLiteral(parsedNumber, startPos);
        }
        return parsedNumber;
    }

    protected Number getJSONNumber() {
        int sign = 1;
        if (this.get() == '-') {
            this.skipChar();
            sign = -1;
        }
        if (!this.posValid()) {
            throw this.error(MALFORMED_NUMBER);
        }
        int startPos = this.pos;
        int fractionPos = -1;
        boolean firstPosIsZero = false;
        char c2 = this.get();
        while (JSRuntime.isAsciiDigit(c2) || c2 == '.') {
            if (c2 == '.') {
                if (fractionPos >= 0) {
                    throw this.error(MALFORMED_NUMBER);
                }
                fractionPos = this.pos;
            } else if (this.pos == startPos && c2 == '0') {
                firstPosIsZero = true;
            }
            this.skipChar();
            if (!this.posValid()) break;
            c2 = this.get(this.pos);
        }
        if (this.pos == startPos) {
            throw this.unexpectedToken();
        }
        if (firstPosIsZero && startPos + 1 < this.len && ((c2 = this.get(startPos + 1)) == 'x' || c2 == 'X' || JSRuntime.isAsciiDigit(c2))) {
            throw this.error("octal and hexadecimal not allowed");
        }
        if (fractionPos == startPos || fractionPos == this.pos - 1) {
            throw this.error(MALFORMED_NUMBER);
        }
        boolean hasExponent = false;
        if (this.posValid() && this.isExponentPart()) {
            hasExponent = true;
            this.skipExponent();
        }
        int endPos = this.pos;
        if (firstPosIsZero && endPos - startPos == 1) {
            if (sign == 1) {
                return 0;
            }
            return -0.0;
        }
        if (fractionPos == -1 && !hasExponent && endPos - startPos <= 16) {
            int radix = 10;
            long safeInt = JSRuntime.parseSafeInteger(this.parseStr, startPos, endPos, 10);
            assert (safeInt != 0L);
            if (safeInt != Long.MIN_VALUE) {
                if (JSRuntime.longIsRepresentableAsInt(safeInt *= (long)sign)) {
                    return (int)safeInt;
                }
                return (double)safeInt;
            }
        }
        TruffleString valueStr = Strings.lazySubstring(this.parseStr, startPos, endPos - startPos);
        return this.parseAsDouble(sign, valueStr);
    }

    protected Number parseAsDouble(int sign, TruffleString valueStr) {
        try {
            return Strings.parseDouble(valueStr) * (double)sign;
        }
        catch (TruffleString.NumberFormatException e2) {
            throw this.error(MALFORMED_NUMBER);
        }
    }

    protected void skipExponent() {
        this.skipChar();
        char cur = this.get();
        if (cur == '-') {
            this.skipChar('-');
        } else if (cur == '+') {
            this.skipChar('+');
        }
        if (!this.posValid()) {
            throw this.error(MALFORMED_NUMBER);
        }
        cur = this.get();
        int startPos = this.pos;
        while (JSRuntime.isAsciiDigit(cur)) {
            this.skipChar();
            if (!this.posValid()) break;
            cur = this.get(this.pos);
        }
        if (this.pos == startPos) {
            throw this.error("Expected number but found ident");
        }
    }

    protected boolean isExponentPart() {
        return this.get() == 'e' || this.get() == 'E';
    }

    protected boolean isNullLiteral(char c2) {
        return c2 == 'n' && this.isLiteral(Strings.NULL, 1);
    }

    protected Object parseNullLiteral() {
        int startPos = this.pos;
        Object parsedNull = this.getNullLiteral();
        if (this.withSource) {
            return this.parseRecordForLiteral(parsedNull, startPos);
        }
        return parsedNull;
    }

    protected Object getNullLiteral() {
        assert (this.isNullLiteral(this.get()));
        this.skipString(Strings.NULL);
        return Null.instance;
    }

    protected boolean isBooleanLiteral(char c2) {
        return c2 == 't' && this.isLiteral(Strings.TRUE, 1) || c2 == 'f' && this.isLiteral(Strings.FALSE, 1);
    }

    protected Object parseBooleanLiteral() {
        int startPos = this.pos;
        boolean parsedBoolean = this.getBooleanLiteral();
        if (this.withSource) {
            return this.parseRecordForLiteral(parsedBoolean, startPos);
        }
        return parsedBoolean;
    }

    protected boolean getBooleanLiteral() {
        assert (this.isBooleanLiteral(this.get()));
        if (this.get() == 't') {
            this.skipString(Strings.TRUE);
            return true;
        }
        if (this.get() == 'f') {
            this.skipString(Strings.FALSE);
            return false;
        }
        throw this.error("cannot parse JSONBooleanLiteral");
    }

    protected static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t';
    }

    protected RuntimeException error(String message) {
        if (this.context.isOptionNashornCompatibilityMode()) {
            NashornJSONParser parser = new NashornJSONParser(this.parseStr, this.context);
            try {
                parser.parse();
            }
            catch (ParserException ex) {
                String msg = ex.getMessage().replace("\r\n", "\n");
                throw Errors.createSyntaxError("Invalid JSON: " + msg);
            }
            throw Errors.shouldNotReachHere("JSON parser did not throw error as expected");
        }
        assert (!message.contains("at position"));
        throw Errors.createSyntaxError(message + " at position " + this.pos);
    }

    private RuntimeException unexpectedToken() {
        throw this.error("Unexpected token " + this.get() + " in JSON");
    }

    private RuntimeException unexpectedString() {
        throw this.error("Unexpected string in JSON");
    }

    private RuntimeException unexpectedNumber() {
        throw this.error("Unexpected number in JSON");
    }

    protected char get() {
        return this.get(this.pos);
    }

    protected char get(int posParam) {
        return Strings.charAt(this.parseStr, posParam);
    }

    protected void skipString(TruffleString expected) {
        int length = Strings.length(expected);
        assert (this.len >= this.pos + length);
        assert (Strings.equals(Strings.lazySubstring(this.parseStr, this.pos, length), expected));
        this.pos += length;
    }

    protected void expectChar(char expected) {
        if (this.get(this.pos) != expected) {
            throw this.error(expected + " expected");
        }
        this.skipChar(expected);
    }

    protected void skipChar() {
        assert (this.posValid());
        ++this.pos;
    }

    protected void skipChar(char expected) {
        assert (this.get(this.pos) == expected);
        this.skipChar();
    }

    protected void skipWhitespace() {
        while (this.posValid() && TruffleJSONParser.isWhitespace(this.get())) {
            ++this.pos;
        }
    }

    protected boolean posValid() {
        return this.pos < this.len;
    }

    protected boolean isLiteral(TruffleString literalStr, int literalPos) {
        if (this.len < this.pos + Strings.length(literalStr)) {
            return false;
        }
        int startPos = this.pos + literalPos;
        return TruffleString.RegionEqualByteIndexNode.getUncached().execute((AbstractTruffleString)this.parseStr, startPos << 1, literalStr, literalPos << 1, literalStr.byteLength(TruffleString.Encoding.UTF_16) - (literalPos << 1), TruffleString.Encoding.UTF_16);
    }

    private Object parseRecordForLiteral(Object parsedValue, int startPos) {
        TruffleString source = Strings.lazySubstring(this.parseStr, startPos, this.pos - startPos);
        return JSONParseRecord.forLiteral(parsedValue, source);
    }

    public static enum Mode {
        RawJSON,
        WithoutReviver,
        WithReviver,
        WithReviverAndSource;

    }
}

