/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.compiler;

public final class ConstantFieldInfo {
    private final int rawValue;
    public static final ConstantFieldInfo CHILD = new ConstantFieldInfo(-1);
    public static final ConstantFieldInfo CHILDREN = new ConstantFieldInfo(-2);
    private static final ConstantFieldInfo FINAL_DIMENSIONS_ZERO = new ConstantFieldInfo(0);
    private static final ConstantFieldInfo FINAL_DIMENSIONS_ONE = new ConstantFieldInfo(1);
    private static final ConstantFieldInfo FINAL_DIMENSIONS_TWO = new ConstantFieldInfo(2);

    private ConstantFieldInfo(int rawValue) {
        this.rawValue = rawValue;
    }

    public boolean isChild() {
        return this == CHILD;
    }

    public boolean isChildren() {
        return this == CHILDREN;
    }

    public int getDimensions() {
        return Math.max(0, this.rawValue);
    }

    public static ConstantFieldInfo forDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException("Negative dimensions not allowed");
        }
        switch (dimensions) {
            case 0: {
                return FINAL_DIMENSIONS_ZERO;
            }
            case 1: {
                return FINAL_DIMENSIONS_ONE;
            }
            case 2: {
                return FINAL_DIMENSIONS_TWO;
            }
        }
        return new ConstantFieldInfo(dimensions);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantFieldInfo) {
            ConstantFieldInfo o2 = (ConstantFieldInfo)obj;
            return this.rawValue == o2.rawValue;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.rawValue);
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (this.isChild()) {
            return simpleName + "[@Child]";
        }
        if (this.isChildren()) {
            return simpleName + "[@Children]";
        }
        return simpleName + "[@CompilationFinal(dimensions=" + this.getDimensions() + ")]";
    }
}

