/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.math.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;

public class RotationUtils {
    public static Direction getPlacedRotationHorizontal(LivingEntity entity) {
        int facing = MathHelper.floor((double)(entity.getYRot() * 4.0f / 360.0f) + 0.5) & 3;
        return RotationUtils.entityRotationToSide(facing).getOpposite();
    }

    public static Direction getPlacedRotation(BlockPos pos, LivingEntity entity) {
        int entityRotation = (int)Math.floor((double)(entity.getYRot() * 4.0f / 360.0f) + 0.5) & 3;
        if (Math.abs(entity.getX() - (double)pos.getX()) < 2.0 && Math.abs(entity.getZ() - (double)pos.getZ()) < 2.0) {
            double eyeDistance = entity.getY() + 1.82 - (double)pos.getY();
            if (eyeDistance > 2.0) {
                return Direction.DOWN;
            }
            if (eyeDistance < 0.0) {
                return Direction.UP;
            }
        }
        return RotationUtils.entityRotationToSide(entityRotation);
    }

    public static Direction getPlacedRotation(BlockPos pos, LivingEntity entity, boolean onlyHorizon) {
        if (onlyHorizon) {
            return RotationUtils.getPlacedRotationHorizontal(entity);
        }
        return RotationUtils.getPlacedRotation(pos, entity);
    }

    public static Direction rotateCounterClockwise(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Direction.WEST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.WEST -> Direction.SOUTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(facing));
        };
    }

    public static Direction rotateClockwise(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> throw new IllegalStateException("Unable to get CW facing of " + String.valueOf(facing));
        };
    }

    public static Direction rotateForward(Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Direction.DOWN;
            case Direction.DOWN -> Direction.UP;
            case Direction.UP -> Direction.WEST;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
        };
    }

    public static Direction rotateBackwards(Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.EAST -> Direction.WEST;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.NORTH;
        };
    }

    public static Direction entityRotationToSide(int rotation) {
        return switch (rotation) {
            case 0 -> Direction.SOUTH;
            case 1 -> Direction.WEST;
            case 2 -> Direction.NORTH;
            default -> Direction.EAST;
        };
    }
}

