/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedRecipeBuilder
extends AbstractItemStackRecipeBuilder<ShapedRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private final Factory factory;
    private final List<String> patternLines = new ArrayList<String>();
    private final Char2ObjectMap<Ingredient> keys = new Char2ObjectOpenHashMap();
    private CraftingBookCategory category = CraftingBookCategory.MISC;
    private boolean showNotification = true;

    protected ShapedRecipeBuilder(ResourceLocation id, ItemStack result, Factory factory) {
        super(id, result);
        this.factory = factory;
    }

    public static ShapedRecipeBuilder builder(ItemLike result) {
        return ShapedRecipeBuilder.builder(result, 1);
    }

    public static ShapedRecipeBuilder builder(ItemLike result, int count) {
        return ShapedRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static ShapedRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return ShapedRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static ShapedRecipeBuilder builder(Supplier<? extends ItemLike> result) {
        return ShapedRecipeBuilder.builder(result.get(), 1);
    }

    public static ShapedRecipeBuilder builder(Supplier<? extends ItemLike> result, int count) {
        return ShapedRecipeBuilder.builder(new ItemStack(result.get(), count));
    }

    public static ShapedRecipeBuilder builder(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return ShapedRecipeBuilder.builder(new ItemStack(result.get(), count), id);
    }

    public static ShapedRecipeBuilder builder(ItemStack result) {
        return ShapedRecipeBuilder.builder(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static ShapedRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new ShapedRecipeBuilder(id, result, ShapedRecipe::new);
    }

    public static ShapedRecipeBuilder custom(ItemLike result, Factory factory) {
        return ShapedRecipeBuilder.custom(result, 1, factory);
    }

    public static ShapedRecipeBuilder custom(ItemLike result, int count, Factory factory) {
        return ShapedRecipeBuilder.custom(new ItemStack(result, count), factory);
    }

    public static ShapedRecipeBuilder custom(ItemLike result, int count, ResourceLocation id, Factory factory) {
        return ShapedRecipeBuilder.custom(new ItemStack(result, count), id, factory);
    }

    public static ShapedRecipeBuilder custom(ItemStack result, Factory factory) {
        return ShapedRecipeBuilder.custom(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()), factory);
    }

    public static ShapedRecipeBuilder custom(ItemStack result, ResourceLocation id, Factory factory) {
        return new ShapedRecipeBuilder(id, result, factory);
    }

    public ShapedRecipeBuilder key(char key, TagKey<Item> item) {
        this.addAutoCriteria(item);
        return this.keyInternal(key, Ingredient.of(item));
    }

    public ShapedRecipeBuilder key(char key, ItemLike item) {
        this.addAutoCriteria(item);
        return this.keyInternal(key, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedRecipeBuilder key(char key, Supplier<? extends ItemLike> item) {
        this.addAutoCriteria(item.get());
        return this.keyInternal(key, Ingredient.of((ItemLike[])new ItemLike[]{item.get()}));
    }

    public ShapedRecipeBuilder key(char key, Ingredient ingredient) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        return this.keyInternal(key, ingredient);
    }

    private ShapedRecipeBuilder keyInternal(char key, Ingredient ingredient) {
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.keys.put(key, (Object)ingredient);
        return this;
    }

    public ShapedRecipeBuilder patternLine(String patternIn) {
        if (!this.patternLines.isEmpty() && patternIn.length() != this.patternLines.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.patternLines.add(patternIn);
        return this;
    }

    public ShapedRecipeBuilder category(CraftingBookCategory category) {
        this.category = category;
        return this;
    }

    public ShapedRecipeBuilder showNotifications(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    @Override
    public Recipe<?> _build() {
        return this.factory.build(this.group, this.category, ShapedRecipePattern.of(this.keys, this.patternLines), (ItemStack)this.result, this.showNotification);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.patternLines.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(this.id) + "!", this.created);
        }
        if (this.patternLines.size() == 1 && this.patternLines.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(this.id) + " only takes in a single item - should it be a shapeless recipe instead?", this.created);
        }
        CharOpenHashSet chars = new CharOpenHashSet((CharCollection)this.keys.keySet());
        chars.remove(' ');
        for (String line : this.patternLines) {
            for (char c : line.toCharArray()) {
                if (c == ' ') continue;
                if (!this.keys.containsKey(c)) {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(this.id) + " uses undefined symbol '" + c + "'", this.created);
                }
                chars.remove(c);
            }
        }
        if (!chars.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(this.id), this.created);
        }
    }

    public static interface Factory {
        public Recipe<?> build(String var1, CraftingBookCategory var2, ShapedRecipePattern var3, ItemStack var4, boolean var5);
    }
}

