/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.common.block;

import cy.jdkdigital.chromacarvings.ChromaCarvings;
import cy.jdkdigital.chromacarvings.registry.ModTags;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class ColoredCarvedPumpkinBlock
extends CarvedPumpkinBlock {
    @Nullable
    private BlockPattern snowGolemFull;
    @Nullable
    private BlockPattern ironGolemFull;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = state -> state != null && (state.is(ModTags.Blocks.PUMPKINS_CARVED) || state.is(ModTags.Blocks.JACK_O_LANTERNS));

    public ColoredCarvedPumpkinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.trySpawnGolem(level, pos);
        }
    }

    private void trySpawnGolem(Level level, BlockPos pos) {
        BlockPattern.BlockPatternMatch snowGolemBlockPattern = this.getOrCreateSnowGolemFull().find((LevelReader)level, pos);
        if (snowGolemBlockPattern != null) {
            BlockState blockAt = snowGolemBlockPattern.getBlock(0, 0, 0).getState();
            EntityType<?> golemType = ChromaCarvings.getGolemFromPumpkin(blockAt);
            Entity snowgolem = golemType.create(level);
            if (snowgolem != null) {
                ColoredCarvedPumpkinBlock.spawnGolemInWorld((Level)level, (BlockPattern.BlockPatternMatch)snowGolemBlockPattern, (Entity)snowgolem, (BlockPos)snowGolemBlockPattern.getBlock(0, 2, 0).getPos());
            }
        } else {
            IronGolem irongolem;
            BlockPattern.BlockPatternMatch ironGolemBlockPattern = this.getOrCreateIronGolemFull().find((LevelReader)level, pos);
            if (ironGolemBlockPattern != null && (irongolem = (IronGolem)EntityType.IRON_GOLEM.create(level)) != null) {
                irongolem.setPlayerCreated(true);
                ColoredCarvedPumpkinBlock.spawnGolemInWorld((Level)level, (BlockPattern.BlockPatternMatch)ironGolemBlockPattern, (Entity)irongolem, (BlockPos)ironGolemBlockPattern.getBlock(1, 2, 0).getPos());
            }
        }
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "#", "#"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemFull;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('~', p_284868_ -> p_284868_.getState().isAir()).build();
        }
        return this.ironGolemFull;
    }
}

