/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildingUtils {
    public static final Predicate<JobEntry> UNRESTRICTED = job -> true;

    private BuildingUtils() {
    }

    public static ItemStack getItemStackForHutFromInventory(Inventory inventory, String hut) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith(IItemHandlerCapProvider.wrap((Entity)inventory.player, false), item -> item.getItem() instanceof BlockItem && ((BlockItem)item.getItem()).getBlock() instanceof AbstractBlockHut && BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)item.getItem()).getBlock()).getPath().endsWith(hut));
        if (slot != -1) {
            return inventory.getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public static Predicate<JobEntry> getAllowedJobs(@NotNull Level world, @NotNull BlockPos buildingPos) {
        IBlueprintDataProviderBE provider;
        Set jobTags;
        BlockEntity blockEntity = world.getBlockEntity(buildingPos);
        if (blockEntity instanceof IBlueprintDataProviderBE && !(jobTags = ((List)(provider = (IBlueprintDataProviderBE)blockEntity).getPositionedTags().getOrDefault(BlockPos.ZERO, new ArrayList())).stream().filter(t -> t.startsWith("job=")).map(t -> t.substring(4)).collect(Collectors.toSet())).isEmpty()) {
            return job -> jobTags.contains(job.getKey().getPath()) || jobTags.contains(job.getKey().toString());
        }
        return UNRESTRICTED;
    }

    public static boolean canAutoHire(@NotNull IBuilding building, @NotNull HiringMode hiringMode, @Nullable JobEntry job) {
        return building.canAssignCitizens() && (hiringMode == HiringMode.DEFAULT && !building.getColony().isManualHiring() || hiringMode == HiringMode.AUTO) && (job == null || BuildingUtils.getAllowedJobs(building.getColony().getWorld(), building.getPosition()).test(job));
    }
}

