/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemCompost
extends AbstractItemMinecolonies {
    public ItemCompost(Item.Properties properties) {
        super("compost", properties.stacksTo(64));
    }

    private static boolean applyCompost(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof MinecoloniesCropBlock) {
            MinecoloniesCropBlock cropBlock = (MinecoloniesCropBlock)block;
            if (!cropBlock.isMaxAge(state)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    cropBlock.attemptGrow(state, serverLevel, pos);
                    stack.shrink(1);
                }
                return true;
            }
            return false;
        }
        return BoneMealItem.applyBonemeal((ItemStack)stack, (Level)level, (BlockPos)pos, (Player)player);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (ItemCompost.applyCompost(ctx.getItemInHand(), ctx.getLevel(), ctx.getClickedPos(), ctx.getPlayer())) {
            if (!ctx.getLevel().isClientSide) {
                ctx.getLevel().levelEvent(1505, ctx.getClickedPos(), 0);
            }
            return InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide);
        }
        return InteractionResult.PASS;
    }
}

