/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingConstructionModEvent;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.eventhooks.buildingEvents.BuildingBuiltEvent;
import com.minecolonies.core.colony.eventhooks.buildingEvents.BuildingDeconstructedEvent;
import com.minecolonies.core.colony.eventhooks.buildingEvents.BuildingRepairedEvent;
import com.minecolonies.core.colony.eventhooks.buildingEvents.BuildingUpgradedEvent;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.colony.workorders.WorkOrderBuilding;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructure;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.entity.ai.workers.util.BuildingStructureHandler;
import com.minecolonies.core.entity.ai.workers.util.WorkerLoadOnlyStructureHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIStructure<J, B> {
    protected RequestStage requestState = RequestStage.SOLID;
    protected BlockPos requestProgress = null;
    private boolean recalculated = false;

    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, BuildingProgressStage stage) {
        ((AbstractBuildingStructureBuilder)this.building).setProgressPos(blockPos, stage);
        this.worker.getCitizenData().setStatusPosition(blockPos.equals((Object)AbstractBlueprintIterator.NULL_POS) ? null : ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getProgressPosInWorld(blockPos));
    }

    @Override
    public Tuple<BlockPos, BuildingProgressStage> getProgressPos() {
        return ((AbstractBuildingStructureBuilder)this.building).getProgress();
    }

    @Override
    public IAIState loadRequirements() {
        if (this.loadingBlueprint) {
            return this.getState();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder() == null || ((AbstractJobStructure)this.job).getWorkOrder().getBlueprint() == null || this.structurePlacer == null) {
            this.loadStructure();
            IBuilderWorkOrder wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColonyOrRegister().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()), (Throwable)new Exception());
                ((AbstractJobStructure)this.job).setWorkOrder(null);
                return AIWorkerState.IDLE;
            }
            if (wo instanceof WorkOrderBuilding) {
                IBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColonyOrRegister().getID(), this.worker.getCitizenData().getId(), wo.getLocation()), (Throwable)new Exception());
                    return AIWorkerState.IDLE;
                }
                MessageUtils.forCitizen(this.worker, "entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getWorkOrder().getDisplayName()).sendTo(this.worker.getCitizenColonyHandler().getColonyOrRegister().getMessagePlayerEntities());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderMiner)) {
                MessageUtils.forCitizen(this.worker, "entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getWorkOrder().getDisplayName()).sendTo(this.worker.getCitizenColonyHandler().getColonyOrRegister().getMessagePlayerEntities());
            }
            return this.getState();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder().isRequested()) {
            return this.afterStructureLoading();
        }
        this.requestMaterialsState();
        return this.getState();
    }

    private void loadStructure() {
        IBuilderWorkOrder workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getLocation();
        if (workOrder instanceof WorkOrderBuilding && this.worker.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColonyOrRegister().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        boolean removal = workOrder.getWorkOrderType() == WorkOrderType.REMOVE;
        this.loadStructure(workOrder, pos, removal);
        workOrder.setCleared(false);
        workOrder.setRequested(removal);
    }

    private void requestMaterialsState() {
        if (Constants.BUILDER_INF_RESOURECES || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder().getWorkOrderType() == WorkOrderType.REMOVE) {
            this.recalculated = true;
            return;
        }
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
        if (this.requestMaterials()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
        }
        int newQuantity = buildingWorker.getNeededResources().values().stream().mapToInt(ItemStorage::getAmount).sum();
        if (((AbstractJobStructure)this.job).getWorkOrder().getAmountOfResources() == 0 || newQuantity > ((AbstractJobStructure)this.job).getWorkOrder().getAmountOfResources()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setAmountOfResources(newQuantity);
        }
    }

    @Override
    protected boolean checkIfNeedsItem() {
        if (!(!((AbstractJobStructure)this.job).hasWorkOrder() || !((AbstractBuildingStructureBuilder)this.building).getNeededResources().isEmpty() || ((AbstractBuildingStructureBuilder)this.building).hasCitizenCompletedRequests(this.worker.getCitizenData()) || this.recalculated || this.structurePlacer != null && ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint() && ((AbstractJobStructure)this.job).getWorkOrder().isRequested())) {
            return false;
        }
        return super.checkIfNeedsItem();
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler structure = new WorkerLoadOnlyStructureHandler((Level)this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), RotationMirror.NONE, true, this);
        if (((AbstractJobStructure)this.job).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((AbstractJobStructure)this.job).getWorkOrder().setIteratorType(mode);
        }
        StructurePlacer placer = new StructurePlacer(structure, ((AbstractJobStructure)this.job).getWorkOrder().getIteratorType());
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
            buildingWorker.resetNeededResources();
            this.requestProgress = AbstractBlueprintIterator.NULL_POS;
            this.requestState = RequestStage.SOLID;
        }
        RequestStage currState = this.requestState;
        switch (currState.ordinal()) {
            case 0: {
                StructurePhasePlacementResult result = placer.executeStructureStep((Level)this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.canBlockFloatInAir((BlockState)info.getBlockInfo().getState()) || AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().getBlock()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.getCount());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.WEAK_SOLID;
                }
                return false;
            }
            case 1: {
                StructurePhasePlacementResult result = placer.executeStructureStep((Level)this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.isWeakSolidBlock((BlockState)info.getBlockInfo().getState()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.getCount());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.DECO;
                }
                return false;
            }
            case 2: {
                StructurePhasePlacementResult result = placer.executeStructureStep((Level)this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) && !AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().getBlock()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.getCount());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.ENTITIES;
                }
                return false;
            }
            case 3: {
                StructurePhasePlacementResult result = placer.executeStructureStep((Level)this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.getCount());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.SOLID;
                    this.requestProgress = null;
                    this.recalculated = true;
                    return true;
                }
                return false;
            }
        }
        this.recalculated = true;
        return true;
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode = stack.getComponentsPatch().hashCode();
        if (((AbstractBuildingStructureBuilder)this.building).getNeededResources().get(stack.getDescriptionId() + "-" + hashCode) == null) {
            ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack)) {
            return 0;
        }
        int hashCode = deliveredItemStack.getComponentsPatch().hashCode();
        BuildingBuilderResource resource = ((AbstractBuildingStructureBuilder)this.building).getNeededResources().get(deliveredItemStack.getDescriptionId() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((AbstractJobStructure)this.job).getWorkOrder().getBlueprint() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder().getBlueprint() == null) {
            return;
        }
        IBuilderWorkOrder wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColonyOrRegister().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            String workOrderName = wo.getTranslationKey();
            this.sendCompletionMessage(wo);
            IColony colony = ((AbstractJobStructure)this.job).getColony();
            switch (wo.getWorkOrderType()) {
                case BUILD: {
                    StatsUtil.trackStat(this.worker.getCitizenData().getWorkBuilding(), "build_built", 1);
                    colony.getEventDescriptionManager().addEventDescription(new BuildingBuiltEvent(wo.getLocation(), workOrderName));
                    this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("build_built", colony.getDay());
                    break;
                }
                case UPGRADE: {
                    StatsUtil.trackStat(this.worker.getCitizenData().getWorkBuilding(), "build_upgraded", 1);
                    colony.getEventDescriptionManager().addEventDescription(new BuildingUpgradedEvent(wo.getLocation(), workOrderName, wo.getTargetLevel()));
                    this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("build_upgraded", colony.getDay());
                    break;
                }
                case REPAIR: {
                    StatsUtil.trackStat(this.worker.getCitizenData().getWorkBuilding(), "build_repaired", 1);
                    colony.getEventDescriptionManager().addEventDescription(new BuildingRepairedEvent(wo.getLocation(), workOrderName, wo.getCurrentLevel()));
                    this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("build_repaired", colony.getDay());
                    break;
                }
                case REMOVE: {
                    StatsUtil.trackStat(this.worker.getCitizenData().getWorkBuilding(), "build_removed", 1);
                    colony.getEventDescriptionManager().addEventDescription(new BuildingDeconstructedEvent(wo.getLocation(), workOrderName, wo.getCurrentLevel()));
                    this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("build_removed", colony.getDay());
                }
            }
            ((AbstractJobStructure)this.job).complete();
            if (wo instanceof WorkOrderBuilding) {
                WorkOrderBuilding workOrderBuilding = (WorkOrderBuilding)wo;
                IBuilding building = colony.getBuildingManager().getBuilding(wo.getLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColonyOrRegister().getID(), this.worker.getCitizenData().getId(), wo.getLocation()));
                } else {
                    switch (wo.getWorkOrderType()) {
                        case BUILD: 
                        case UPGRADE: 
                        case REPAIR: {
                            BlockEntity te = this.worker.level().getBlockEntity(building.getID());
                            if (!(te instanceof AbstractTileEntityColonyBuilding) || !((IBlueprintDataProviderBE)te).getSchematicName().isEmpty()) break;
                            building.onUpgradeComplete(wo.getTargetLevel());
                            building.setBuildingLevel(wo.getTargetLevel());
                            break;
                        }
                        case REMOVE: {
                            building.setDeconstructed();
                        }
                    }
                    IMinecoloniesAPI.getInstance().getEventBus().post(new BuildingConstructionModEvent(building, workOrderBuilding));
                }
            }
        }
        ((AbstractBuildingStructureBuilder)this.building).resetNeededResources();
    }

    protected void sendCompletionMessage(IWorkOrder wo) {
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        ((AbstractBuildingStructureBuilder)this.building).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && this.structurePlacer != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint()) {
            if (((AbstractJobStructure)this.job).hasWorkOrder()) {
                ((AbstractJobStructure)this.job).getWorkOrder().clearBlueprint();
                ((AbstractJobStructure)this.job).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
            }
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((AbstractBuildingStructureBuilder)this.building).cancelAllRequestsOfCitizenOrBuilding(this.worker.getCitizenData());
            ((AbstractBuildingStructureBuilder)this.building).cancelAllRequestsOfCitizenOrBuilding(null);
            ((AbstractBuildingStructureBuilder)this.building).setProgressPos(null, BuildingProgressStage.CLEAR);
            return true;
        }
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((LevelAccessor)this.world, ((AbstractJobStructure)this.job).getWorkOrder().getLocation());
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return null;
        }
        int hashCode = stack.getComponentsPatch().hashCode();
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.getDescriptionId() + "-" + hashCode);
        if (resource == null) {
            this.requestMaterials();
            resource = buildingWorker.getNeededResources().get(stack.getDescriptionId() + "-" + hashCode);
        }
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = resource.getItemStack().copy();
        resStack.setCount(Math.min(64, resource.getAmount()));
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractBuildingStructureBuilder)this.building).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }

    protected static enum RequestStage {
        SOLID,
        WEAK_SOLID,
        DECO,
        ENTITIES;

    }
}

