/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.IJeiProxy;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.eventbus.events.CustomRecipesReloadedEvent;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.crafting.RecipeAnalyzer;
import com.minecolonies.core.compatibility.jei.CompostRecipeCategory;
import com.minecolonies.core.compatibility.jei.CropRecipeCategory;
import com.minecolonies.core.compatibility.jei.FishermanRecipeCategory;
import com.minecolonies.core.compatibility.jei.FloristRecipeCategory;
import com.minecolonies.core.compatibility.jei.GenericRecipeCategory;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.ModRecipeTypes;
import com.minecolonies.core.compatibility.jei.ToolRecipeCategory;
import com.minecolonies.core.compatibility.jei.transfer.BrewingCraftingGuiHandler;
import com.minecolonies.core.compatibility.jei.transfer.CraftingGuiHandler;
import com.minecolonies.core.compatibility.jei.transfer.FurnaceCraftingGuiHandler;
import com.minecolonies.core.compatibility.jei.transfer.PrivateBrewingTeachingTransferHandler;
import com.minecolonies.core.compatibility.jei.transfer.PrivateCraftingTeachingTransferHandler;
import com.minecolonies.core.compatibility.jei.transfer.PrivateSmeltingTeachingTransferHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @Nullable
    IJeiRuntime jei;
    boolean recipesLoaded;
    private final List<JobBasedRecipeCategory<?>> categories = new ArrayList();

    public JEIPlugin() {
        Compatibility.jeiProxy = new IJeiProxy(){

            @Override
            public boolean isLoaded() {
                return true;
            }

            @Override
            public boolean showRecipes(Collection<ItemStack> stacks) {
                IJeiRuntime jei = JEIPlugin.this.jei;
                if (jei != null && !stacks.isEmpty()) {
                    IFocusFactory focusFactory = jei.getJeiHelpers().getFocusFactory();
                    List<IFocus> focuses = stacks.stream().map(stack -> focusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, stack)).toList();
                    jei.getRecipesGui().show(focuses);
                    return true;
                }
                return false;
            }
        };
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("minecolonies", "minecolonies");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CropRecipeCategory(guiHelper), new ToolRecipeCategory(guiHelper), new CompostRecipeCategory(guiHelper), new FishermanRecipeCategory(guiHelper), new FloristRecipeCategory(guiHelper)});
        this.categories.clear();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            HashMap<JobEntry, GenericRecipeCategory> craftingCategories = new HashMap<JobEntry, GenericRecipeCategory>();
            for (BuildingEntry.ModuleProducer producer : building.getModuleProducers()) {
                GenericRecipeCategory category;
                IJob<?> job;
                IBuildingModule module;
                if (!producer.hasServerModule() || (module = BuildingEntry.produceModuleWithoutBuilding(producer.key)) == null) continue;
                if (module instanceof ICraftingBuildingModule) {
                    ICraftingBuildingModule crafting = (ICraftingBuildingModule)module;
                    job = crafting.getCraftingJob();
                    if (job == null) continue;
                    category = (GenericRecipeCategory)((Object)craftingCategories.get(job.getJobRegistryEntry()));
                    if (category == null) {
                        category = new GenericRecipeCategory(building, job, guiHelper, modIdHelper);
                        craftingCategories.put(job.getJobRegistryEntry(), category);
                    }
                    category.addModule(crafting);
                    continue;
                }
                if (!(module instanceof AnimalHerdingModule)) continue;
                AnimalHerdingModule herding = (AnimalHerdingModule)module;
                job = herding.getHerdingJob();
                category = (GenericRecipeCategory)((Object)craftingCategories.get(job.getJobRegistryEntry()));
                if (category == null) {
                    category = new GenericRecipeCategory(building, job, guiHelper, modIdHelper);
                    craftingCategories.put(job.getJobRegistryEntry(), category);
                }
                category.addModule(herding);
            }
            for (GenericRecipeCategory category : craftingCategories.values()) {
                this.registerCategory(registration, category);
            }
        }
    }

    private void registerCategory(@NotNull IRecipeCategoryRegistration registration, @NotNull JobBasedRecipeCategory<?> category) {
        this.categories.add(category);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        IMinecoloniesAPI.getInstance().getEventBus().subscribe(CustomRecipesReloadedEvent.class, this::onRecipesLoaded);
        registration.addIngredientInfo(ModBlocks.blockHutComposter, new Component[]{Component.translatableEscape((String)("com.minecolonies.coremod.jei." + ModJobs.COMPOSTER_ID.getPath()), (Object[])new Object[0])});
    }

    private void onRecipesLoaded(@NotNull CustomRecipesReloadedEvent event) {
        this.recipesLoaded = true;
        if (this.jei != null) {
            IRecipeManager recipeManager = this.jei.getRecipeManager();
            recipeManager.addRecipes(ModRecipeTypes.COMPOSTING, CompostRecipeCategory.findRecipes());
            recipeManager.addRecipes(ModRecipeTypes.FLOWERS, FloristRecipeCategory.findRecipes());
            recipeManager.addRecipes(ModRecipeTypes.TOOLS, ToolRecipeCategory.findRecipes((Level)Minecraft.getInstance().level));
            recipeManager.addRecipes(ModRecipeTypes.CROPS, CropRecipeCategory.findRecipes());
            recipeManager.addRecipes(ModRecipeTypes.FISHING, FishermanRecipeCategory.findRecipes());
            ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
            Map<CraftingType, List<IGenericRecipe>> vanilla = RecipeAnalyzer.buildVanillaRecipesMap(level.getRecipeManager(), (Level)level);
            List<Animal> animals = RecipeAnalyzer.createAnimals((Level)level);
            for (JobBasedRecipeCategory<?> category : this.categories) {
                this.addJobBasedRecipes(vanilla, animals, category, (arg_0, arg_1) -> ((IRecipeManager)recipeManager).addRecipes(arg_0, arg_1), (Level)level);
            }
        }
    }

    private <R> void addJobBasedRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull List<Animal> animals, @NotNull JobBasedRecipeCategory<R> category, @NotNull BiConsumer<RecipeType<R>, List<R>> registrar, @NotNull Level world) {
        try {
            registrar.accept(category.getRecipeType(), category.findRecipes(vanilla, animals, world));
        }
        catch (Exception e) {
            Log.getLogger().error("Failed to process recipes for " + String.valueOf(category.getTitle()), (Throwable)e);
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ModBlocks.blockBarrel, new RecipeType[]{ModRecipeTypes.COMPOSTING});
        registration.addRecipeCatalyst(ModBlocks.blockHutComposter, new RecipeType[]{ModRecipeTypes.COMPOSTING});
        registration.addRecipeCatalyst(ModBlocks.blockHutFisherman, new RecipeType[]{ModRecipeTypes.FISHING});
        registration.addRecipeCatalyst(ModBlocks.blockHutFlorist, new RecipeType[]{ModRecipeTypes.FLOWERS});
        for (JobBasedRecipeCategory<?> category : this.categories) {
            registration.addRecipeCatalyst(category.getCatalyst(), new RecipeType[]{category.getRecipeType()});
        }
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateCraftingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateSmeltingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.SMELTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateBrewingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.BREWING);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        new CraftingGuiHandler(this.categories).register(registration);
        new FurnaceCraftingGuiHandler(this.categories).register(registration);
        new BrewingCraftingGuiHandler(this.categories).register(registration);
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.jei = jeiRuntime;
        if (this.recipesLoaded) {
            this.onRecipesLoaded(new CustomRecipesReloadedEvent());
        }
    }

    public void onRuntimeUnavailable() {
        this.jei = null;
    }
}

