/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.DeliveryRequestResolver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class DeliveryRequestResolverFactory
implements IRequestResolverFactory<DeliveryRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends DeliveryRequestResolver> getFactoryOutputType() {
        return TypeToken.of(DeliveryRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public DeliveryRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new DeliveryRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull DeliveryRequestResolver deliveryRequestResolver) {
        CompoundTag compound = new CompoundTag();
        compound.put(NBT_TOKEN, (Tag)controller.serializeTag(provider, deliveryRequestResolver.getId()));
        compound.put(NBT_LOCATION, (Tag)controller.serializeTag(provider, deliveryRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public DeliveryRequestResolver deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserializeTag(provider, nbt.getCompound(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserializeTag(provider, nbt.getCompound(NBT_LOCATION));
        return new DeliveryRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, DeliveryRequestResolver input, RegistryFriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public DeliveryRequestResolver deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new DeliveryRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return 15;
    }
}

