/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;

public class ColonyWaypointRenderer {
    private static BlueprintPreviewData wayPointTemplate;
    private static Future<Blueprint> pendingTemplate;

    static void render(WorldEventContext ctx) {
        if (!RenderingCache.hasBlueprint((String)"waypoint")) {
            return;
        }
        Blueprint structure = RenderingCache.getOrCreateBlueprintPreviewData((String)"waypoint").getBlueprint();
        if (structure != null && structure.getFilePath().toString().contains("infrastructure") && ctx.nearestColony != null) {
            if (wayPointTemplate == null && pendingTemplate == null) {
                pendingTemplate = StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)"infrastructure/misc/waypoint.blueprint", (HolderLookup.Provider)ctx.clientLevel.registryAccess());
            }
            if (pendingTemplate != null) {
                if (pendingTemplate.isDone()) {
                    try {
                        BlueprintPreviewData tempPreviewData = new BlueprintPreviewData();
                        tempPreviewData.setBlueprint(pendingTemplate.get());
                        tempPreviewData.setPos(BlockPos.ZERO);
                        wayPointTemplate = tempPreviewData;
                        pendingTemplate = null;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                } else {
                    return;
                }
            }
            if (wayPointTemplate == null) {
                return;
            }
            ctx.renderBlueprint(RenderingCache.getOrCreateBlueprintPreviewData((String)"waypoint").getBlueprint().hashCode() == wayPointTemplate.hashCode() ? RenderingCache.getOrCreateBlueprintPreviewData((String)"waypoint") : wayPointTemplate, ctx.nearestColony.getWayPoints().keySet());
        }
    }
}

