/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.core.colony.buildings.moduleviews.WarehouseOptionsModuleView;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class WarehouseOptionsModuleWindow
extends AbstractModuleWindow {
    private static final int BUILDING_LEVEL_FOR_SORTING = 3;
    private final WarehouseOptionsModuleView module;
    private boolean lockUpgrade = false;

    public WarehouseOptionsModuleWindow(IBuildingView building, WarehouseOptionsModuleView module) {
        super(building, "minecolonies:gui/layouthuts/layoutwarehouseoptions.xml");
        this.registerButton("resourceAdd", this::transferItems);
        this.registerButton("sort", this::sortWarehouse);
        this.module = module;
    }

    public void onOpened() {
        if (this.buildingView.getBuildingLevel() < 3) {
            ButtonImage sortButton = (ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.translatableEscape((String)"com.minecolonies.coremod.gui.warehouse.sort.disabled.1", (Object[])new Object[]{3}))).appendNL(Component.translatableEscape((String)"com.minecolonies.coremod.gui.warehouse.sort.disabled.2", (Object[])new Object[]{3}))).hoverPane((Pane)sortButton).build();
            sortButton.disable();
        }
        super.onOpened();
        this.updateResourcePane();
        new MarkBuildingDirtyMessage(this.buildingView).sendToServer();
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK, 1), 1);
        Inventory inventory = this.mc.player.getInventory();
        boolean isCreative = this.mc.player.isCreative();
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)inventory), resource.getItem());
        resource.setPlayerAmount(amountToSet);
        Text resourceLabel = (Text)this.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)this.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)this.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        Button addButton = (Button)this.findPaneOfTypeByID("resourceAdd", Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (this.module.getStorageUpgradeLevel() >= 3 || this.buildingView.getBuildingLevel() < this.buildingView.getBuildingMaxLevel() || this.lockUpgrade) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        ((Text)this.findPaneOfTypeByID("upgradeProgress", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.xofz", (Object[])new Object[]{this.module.getStorageUpgradeLevel(), 3}));
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.DARKGREEN);
                resourceMissingLabel.setColors(WindowBuilderResModule.DARKGREEN);
                neededLabel.setColors(WindowBuilderResModule.DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.BLACK);
                resourceMissingLabel.setColors(WindowBuilderResModule.BLACK);
                neededLabel.setColors(WindowBuilderResModule.BLACK);
                if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) break;
                resourceLabel.hide();
                resourceMissingLabel.hide();
                neededLabel.hide();
                addButton.setText(Component.literal((String)"X").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)));
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.translatableEscape((String)"com.minecolonies.coremod.gui.warehouse.upgrade.disabled.1", (Object[])new Object[]{this.buildingView.getBuildingMaxLevel()}))).appendNL(Component.translatableEscape((String)"com.minecolonies.coremod.gui.warehouse.upgrade.disabled.2", (Object[])new Object[]{this.buildingView.getBuildingMaxLevel()}))).hoverPane((Pane)addButton).build();
            }
        }
        resourceLabel.setText(Component.literal((String)resource.getName()));
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Component.literal((String)Integer.toString(missing)));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(Component.literal((String)(resource.getAvailable() + " / " + resource.getAmount())));
        ((Text)this.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.literal((String)Integer.toString(resource.getAmount() - resource.getAvailable())));
        if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) {
            ItemStack resourceStackOfOne = resource.getItemStack().copy();
            resourceStackOfOne.setCount(1);
            ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resourceStackOfOne);
        }
    }

    private void transferItems() {
        new UpgradeWarehouseMessage(this.buildingView).sendToServer();
        this.module.incrementStorageUpgrade();
        this.lockUpgrade = true;
        this.updateResourcePane();
    }

    private void sortWarehouse() {
        if (this.buildingView.getBuildingLevel() >= 3) {
            new SortWarehouseMessage(this.buildingView).sendToServer();
            MessageUtils.format("com.minecolonies.coremod.gui.warehouse.sorted", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
        }
    }
}

