/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.colony.buildings.moduleviews.LivingBuildingModuleView;
import com.minecolonies.core.colony.buildings.views.LivingBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.home.AssignUnassignMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class WindowAssignCitizen
extends AbstractWindowSkeleton
implements ButtonHandler {
    private static final double FAR_DISTANCE_THRESHOLD = 300.0;
    private final LivingBuildingView building;
    private final ScrollingList unassignedCitizenList;
    private final ScrollingList assignedCitizenList;
    private final IColonyView colony;
    private List<ICitizenDataView> unassignedCitizens = new ArrayList<ICitizenDataView>();
    private final List<ICitizenDataView> assignedCitizens = new ArrayList<ICitizenDataView>();

    public WindowAssignCitizen(IColonyView c, LivingBuildingView building) {
        super("minecolonies:gui/windowassigncitizen.xml");
        this.colony = c;
        this.building = building;
        this.unassignedCitizenList = (ScrollingList)this.findPaneOfTypeByID("unassigned", ScrollingList.class);
        this.assignedCitizenList = (ScrollingList)this.findPaneOfTypeByID("assigned", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("mode", this::modeClicked);
        super.registerButton("hire", this::hireClicked);
        super.registerButton("fire", this::fireClicked);
        this.updateCitizens();
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
    }

    private void hireClicked(@NotNull Button button) {
        int row = this.unassignedCitizenList.getListElementIndexByPane((Pane)button);
        ICitizenDataView data = this.unassignedCitizens.get(row);
        if (this.building.getResidents().size() >= this.building.getMax()) {
            return;
        }
        this.building.addResident(data.getId());
        data.setHomeBuilding(this.building.getPosition());
        new AssignUnassignMessage(this.building, true, data.getId(), null).sendToServer();
        this.updateCitizens();
        this.unassignedCitizenList.refreshElementPanes();
        this.assignedCitizenList.refreshElementPanes();
    }

    private void fireClicked(@NotNull Button button) {
        int row = this.assignedCitizenList.getListElementIndexByPane((Pane)button);
        ICitizenDataView data = this.assignedCitizens.get(row);
        this.building.removeResident(data.getId());
        data.setHomeBuilding(null);
        new AssignUnassignMessage(this.building, false, data.getId(), null).sendToServer();
        this.updateCitizens();
        this.unassignedCitizenList.refreshElementPanes();
        this.assignedCitizenList.refreshElementPanes();
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.building.getHiringMode().ordinal() + 1;
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.building.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setText(Component.translatable((String)("com.minecolonies.coremod.gui.hiringmode." + this.building.getHiringMode().name().toLowerCase(Locale.US))));
    }

    private void updateCitizens() {
        this.unassignedCitizens = this.colony.getCitizens().values().stream().filter(cit -> (!Objects.equals(cit.getHomeBuilding(), cit.getWorkBuilding()) || cit.getHomeBuilding() == null) && !this.building.getPosition().equals((Object)cit.getHomeBuilding())).sorted(Comparator.comparing(cit -> cit.getHomeBuilding() == null ? 0 : 1).thenComparingLong(cit -> {
            if (cit.getWorkBuilding() == null) {
                if (cit.getHomeBuilding() == null) {
                    return 0L;
                }
                return Integer.MAX_VALUE;
            }
            return (int)BlockPosUtil.getDistance(cit.getWorkBuilding(), this.building.getPosition());
        })).toList();
        this.assignedCitizens.clear();
        for (int id : this.building.getModuleViewByType(LivingBuildingModuleView.class).getAssignedCitizens()) {
            this.assignedCitizens.add(this.colony.getCitizen(id));
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateCitizens();
        this.unassignedCitizenList.enable();
        this.unassignedCitizenList.show();
        this.unassignedCitizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowAssignCitizen.this.unassignedCitizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = WindowAssignCitizen.this.unassignedCitizens.get(index);
                Button hireButton = (Button)rowPane.findPaneOfTypeByID("hire", Button.class);
                BlockPos home = citizen.getHomeBuilding();
                BlockPos work = citizen.getWorkBuilding();
                Text citizenLabel = (Text)rowPane.findPaneOfTypeByID("citizen", Text.class);
                citizenLabel.setText(Component.literal((String)citizen.getName()));
                MutableComponent workString = Component.empty();
                int newDistance = 0;
                if (work != null) {
                    newDistance = (int)BlockPosUtil.getDistance(work, WindowAssignCitizen.this.building.getPosition());
                    workString = Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.new", (Object[])new Object[]{newDistance});
                }
                MutableComponent homeString = Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.homeless", (Object[])new Object[0]);
                boolean better = false;
                if (home != null) {
                    if (work != null) {
                        int oldDistance = (int)BlockPosUtil.getDistance(work, home);
                        homeString = Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.currently", (Object[])new Object[]{oldDistance});
                        boolean bl = better = newDistance < oldDistance;
                        if ((double)oldDistance > 300.0) {
                            homeString = homeString.withStyle(ChatFormatting.RED);
                        }
                    } else {
                        homeString = Component.empty();
                    }
                }
                if (better) {
                    workString = workString.withStyle(ChatFormatting.DARK_GREEN);
                }
                Text newLivingLabel = (Text)rowPane.findPaneOfTypeByID("job", Text.class);
                if (citizen.getJobView() != null) {
                    newLivingLabel.setText(Component.empty().append((Component)Component.translatable((String)citizen.getJobView().getEntry().getTranslationKey())).append(": ").append((Component)workString).append(" ").append((Component)homeString));
                } else {
                    newLivingLabel.setText(Component.translatable((String)"com.minecolonies.coremod.gui.townhall.citizens.unemployed").append("\n").append((Component)homeString));
                }
                newLivingLabel.setTextWrap(true);
                if (WindowAssignCitizen.this.colony.isManualHousing() && WindowAssignCitizen.this.building.getHiringMode() == HiringMode.DEFAULT || WindowAssignCitizen.this.building.getHiringMode() == HiringMode.MANUAL) {
                    if (WindowAssignCitizen.this.building.getResidents().size() < WindowAssignCitizen.this.building.getMax()) {
                        hireButton.enable();
                    } else {
                        hireButton.disable();
                    }
                    PaneBuilders.tooltipBuilder().hoverPane((Pane)hireButton).build().setText(Component.empty());
                } else {
                    hireButton.disable();
                    PaneBuilders.tooltipBuilder().hoverPane((Pane)hireButton).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.hire.warning", (Object[])new Object[0]));
                }
            }
        });
        this.assignedCitizenList.enable();
        this.assignedCitizenList.show();
        this.assignedCitizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowAssignCitizen.this.assignedCitizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = WindowAssignCitizen.this.assignedCitizens.get(index);
                Button fireButton = (Button)rowPane.findPaneOfTypeByID("fire", Button.class);
                BlockPos work = citizen.getWorkBuilding();
                fireButton.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.hiring.buttonunassign", (Object[])new Object[0]));
                Text citizenLabel = (Text)rowPane.findPaneOfTypeByID("citizen", Text.class);
                citizenLabel.setText(Component.literal((String)citizen.getName()));
                MutableComponent workString = Component.empty();
                if (work != null) {
                    int newDistance = (int)BlockPosUtil.getDistance(work, WindowAssignCitizen.this.building.getPosition());
                    workString = Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.new", (Object[])new Object[]{newDistance});
                }
                Text newLivingLabel = (Text)rowPane.findPaneOfTypeByID("job", Text.class);
                newLivingLabel.setTextWrap(true);
                if (citizen.getJobView() != null) {
                    int distance;
                    if (work != null && (double)(distance = (int)BlockPosUtil.getDistance(work, WindowAssignCitizen.this.building.getPosition())) > 300.0) {
                        workString = workString.withStyle(ChatFormatting.RED);
                    }
                    newLivingLabel.setText(Component.empty().append((Component)Component.translatableEscape((String)citizen.getJobView().getEntry().getTranslationKey(), (Object[])new Object[0])).append((Component)Component.literal((String)": ")).append((Component)workString));
                } else {
                    newLivingLabel.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.townhall.citizens.unemployed", (Object[])new Object[0]));
                }
                if (WindowAssignCitizen.this.colony.isManualHousing() && WindowAssignCitizen.this.building.getHiringMode() == HiringMode.DEFAULT || WindowAssignCitizen.this.building.getHiringMode() == HiringMode.MANUAL) {
                    if (citizen.getColony().getTravellingManager().isTravelling(citizen.getId())) {
                        fireButton.disable();
                        PaneBuilders.tooltipBuilder().hoverPane((Pane)fireButton).build().setText(Component.translatable((String)"com.minecolonies.coremod.gui.home.travelling"));
                    } else {
                        fireButton.enable();
                    }
                    PaneBuilders.tooltipBuilder().hoverPane((Pane)fireButton).build().setText(Component.empty());
                } else {
                    fireButton.disable();
                    PaneBuilders.tooltipBuilder().hoverPane((Pane)fireButton).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.home.hire.warning", (Object[])new Object[0]));
                }
            }
        });
    }
}

