/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import org.jetbrains.annotations.NotNull;

public class AbstractTileEntityNamedGrave
extends BlockEntity {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private ArrayList<String> textLines = new ArrayList();

    public AbstractTileEntityNamedGrave(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.textLines.add("Unknown Citizen");
    }

    public ArrayList<String> getTextLines() {
        return this.textLines;
    }

    public void setTextLines(ArrayList<String> content) {
        this.textLines = content;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.textLines.clear();
        if (compound.contains("content")) {
            ListTag lines = compound.getList("content", 8);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.getString(i);
                this.textLines.add(line);
            }
        }
    }

    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        @NotNull ListTag lines = new ListTag();
        for (String line : this.textLines) {
            lines.add((Object)StringTag.valueOf((String)line));
        }
        compound.put("content", (Tag)lines);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(packet.getTag(), provider);
    }

    public void handleUpdateTag(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }
}

