/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory;

import com.google.common.collect.Iterables;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryCitizen
implements IItemHandlerModifiable,
Nameable {
    private static final int NO_SLOT = -1;
    private static final int DEFAULT_INV_SIZE = 27;
    private static final int ROW_SIZE = 9;
    private int freeSlots = 27;
    private NonNullList<ItemStack> mainInventory = NonNullList.withSize((int)27, (Object)ItemStackUtils.EMPTY);
    private NonNullList<ItemStack> armorInventory = NonNullList.withSize((int)4, (Object)ItemStackUtils.EMPTY);
    private int mainItem = -1;
    private int offhandItem = -1;
    private String customName;
    private ICitizenData citizen;

    public InventoryCitizen(String title, boolean localeEnabled, ICitizenData citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ItemStack getHeldItem(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return this.getStackInSlot(this.mainItem);
        }
        return this.getStackInSlot(this.offhandItem);
    }

    public void setHeldItem(InteractionHand hand, int slot) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.mainItem = slot;
        }
        this.offhandItem = slot;
    }

    public int getHeldItemSlot(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return this.mainItem;
        }
        return this.offhandItem;
    }

    public int getSlots() {
        return this.mainInventory.size();
    }

    public boolean hasSpace() {
        return this.freeSlots > 0;
    }

    public boolean isEmpty() {
        return this.freeSlots == this.mainInventory.size();
    }

    public boolean isFull() {
        return this.freeSlots == 0;
    }

    private void resizeInventory(int size, int futureSize) {
        if (size < futureSize) {
            NonNullList inv = NonNullList.withSize((int)futureSize, (Object)ItemStackUtils.EMPTY);
            for (int i = 0; i < this.mainInventory.size(); ++i) {
                inv.set(i, (Object)((ItemStack)this.mainInventory.get(i)));
            }
            this.mainInventory = inv;
            this.freeSlots += futureSize - size;
        }
    }

    @NotNull
    public Component getName() {
        return Component.translatableEscape((String)(this.hasCustomName() ? this.customName : "citizen.inventory"), (Object[])new Object[0]);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @NotNull
    public ItemStack getStackInSlot(int index) {
        if (index == -1) {
            return ItemStack.EMPTY;
        }
        if (index >= this.mainInventory.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.mainInventory.get(index);
    }

    public ItemStack getArmorInSlot(EquipmentSlot equipmentSlot) {
        if (equipmentSlot.isArmor()) {
            return (ItemStack)this.armorInventory.get(equipmentSlot.getIndex());
        }
        return ItemStack.EMPTY;
    }

    public void forceArmorStackToSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        this.armorInventory.set(equipmentSlot.getIndex(), (Object)stack);
        if (this.citizen != null) {
            this.citizen.getEntity().ifPresent(citizen -> citizen.onArmorAdd(stack, equipmentSlot));
            this.markDirty();
        }
    }

    public void forceClearArmorInSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (equipmentSlot.isArmor()) {
            this.armorInventory.set(equipmentSlot.getIndex(), (Object)ItemStack.EMPTY);
            if (this.citizen != null) {
                this.citizen.getEntity().ifPresent(citizen -> citizen.onArmorRemove(stack, equipmentSlot));
                this.markDirty();
            }
        }
    }

    public void transferArmorToSlot(EquipmentSlot equipmentSlot, int slot) {
        if (equipmentSlot.isArmor()) {
            this.markDirty();
            ItemStack oldArmorStack = (ItemStack)this.armorInventory.get(equipmentSlot.getIndex());
            ItemStack newArmorStack = this.getStackInSlot(slot);
            if (!oldArmorStack.isEmpty()) {
                this.citizen.getEntity().ifPresent(citizen -> citizen.onArmorRemove(oldArmorStack, equipmentSlot));
            }
            this.armorInventory.set(equipmentSlot.getIndex(), (Object)newArmorStack);
            this.citizen.getEntity().ifPresent(citizen -> citizen.onArmorAdd(newArmorStack, equipmentSlot));
            this.setStackInSlot(slot, oldArmorStack);
        }
    }

    public void moveArmorToInventory(EquipmentSlot equipmentSlot) {
        ItemStack armorStack;
        if (equipmentSlot.isArmor() && InventoryUtils.addItemStackToItemHandler((IItemHandler)this, armorStack = (ItemStack)this.armorInventory.get(equipmentSlot.getIndex()))) {
            this.markDirty();
            this.armorInventory.set(equipmentSlot.getIndex(), (Object)ItemStack.EMPTY);
            this.citizen.getEntity().ifPresent(citizen -> citizen.onArmorRemove(armorStack, equipmentSlot));
        }
    }

    public <T extends LivingEntity> boolean damageInventoryItem(int slot, int amount, @Nullable T entityIn, @Nullable Consumer<Item> onBroken) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack)) {
            stack.hurtAndBreak(stack.getItem().damageItem(stack, amount, entityIn, onBroken), (ServerLevel)entityIn.level(), entityIn, onBroken);
            if (ItemStackUtils.isEmpty(stack)) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    public boolean shrinkInventoryItem(int slot) {
        ItemStack stack = (ItemStack)this.mainInventory.get(slot);
        if (!ItemStackUtils.isEmpty(stack)) {
            stack.setCount(stack.getCount() - 1);
            if (ItemStackUtils.isEmpty(stack)) {
                ++this.freeSlots;
            }
        }
        return ItemStackUtils.isEmpty(stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        ItemStack copy = stack.copy();
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.getCount() >= inSlot.getMaxStackSize() || !inSlot.isEmpty() && !ItemStackUtils.compareItemStacksIgnoreStackSize(inSlot, copy).booleanValue()) {
            return copy;
        }
        if (inSlot.isEmpty()) {
            if (!simulate) {
                this.markDirty();
                --this.freeSlots;
                this.mainInventory.set(slot, (Object)copy);
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        int avail = inSlot.getMaxStackSize() - inSlot.getCount();
        if (avail >= copy.getCount()) {
            if (!simulate) {
                this.markDirty();
                inSlot.setCount(inSlot.getCount() + copy.getCount());
            }
            return ItemStack.EMPTY;
        }
        if (!simulate) {
            this.markDirty();
            inSlot.setCount(inSlot.getCount() + avail);
        }
        copy.setCount(copy.getCount() - avail);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack inSlot = (ItemStack)this.mainInventory.get(slot);
        if (inSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (amount >= inSlot.getCount()) {
            if (!simulate) {
                this.markDirty();
                ++this.freeSlots;
                this.mainInventory.set(slot, (Object)ItemStack.EMPTY);
            }
            return inSlot;
        }
        ItemStack copy = inSlot.copy();
        copy.setCount(amount);
        if (!simulate) {
            this.markDirty();
            inSlot.setCount(inSlot.getCount() - amount);
            if (ItemStackUtils.isEmpty(inSlot)) {
                ++this.freeSlots;
            }
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void markDirty() {
        if (this.citizen != null) {
            this.citizen.markDirty(20);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return this.hasCustomName() ? Component.literal((String)this.customName) : Component.literal((String)this.citizen.getName());
    }

    public void write(@NotNull HolderLookup.Provider provider, CompoundTag nbtTagCompound) {
        double researchEffect;
        if (this.citizen != null && this.citizen.getColony() != null && (researchEffect = this.citizen.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_INV_SLOTS)) > 0.0 && (double)this.mainInventory.size() < 27.0 + researchEffect) {
            this.resizeInventory(this.mainInventory.size(), (int)(27.0 + researchEffect));
        }
        nbtTagCompound.putInt("invsize", this.mainInventory.size());
        ListTag invTagList = new ListTag();
        this.freeSlots = this.mainInventory.size();
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).isEmpty()) continue;
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putByte("slot", (byte)i);
            compoundNBT.put("stack", ((ItemStack)this.mainInventory.get(i)).saveOptional(provider));
            invTagList.add((Object)compoundNBT);
            --this.freeSlots;
        }
        nbtTagCompound.put("inventory", (Tag)invTagList);
        ListTag armorTagList = new ListTag();
        for (int i = 0; i < this.armorInventory.size(); ++i) {
            if (((ItemStack)this.armorInventory.get(i)).isEmpty()) continue;
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putByte("slot", (byte)i);
            compoundNBT.put("stack", ((ItemStack)this.armorInventory.get(i)).saveOptional(provider));
            armorTagList.add((Object)compoundNBT);
        }
        nbtTagCompound.put("armorinventory", (Tag)armorTagList);
    }

    public void read(@NotNull HolderLookup.Provider provider, CompoundTag nbtTagCompound) {
        int size = nbtTagCompound.getInt("invsize");
        if (this.mainInventory.size() < size) {
            size -= size % 9;
            this.mainInventory = NonNullList.withSize((int)size, (Object)ItemStackUtils.EMPTY);
        }
        this.freeSlots = this.mainInventory.size();
        ListTag nbtTagList = nbtTagCompound.getList("inventory", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            CompoundTag compoundNBT = nbtTagList.getCompound(i);
            int j = compoundNBT.getByte("slot") & 0xFF;
            ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundNBT.getCompound("stack"));
            if (itemstack.isEmpty() || j >= this.mainInventory.size()) continue;
            this.mainInventory.set(j, (Object)itemstack);
            --this.freeSlots;
        }
        ListTag armorTagList = nbtTagCompound.getList("armorinventory", 10);
        for (int i = 0; i < armorTagList.size(); ++i) {
            CompoundTag compoundNBT = armorTagList.getCompound(i);
            int j = compoundNBT.getByte("slot") & 0xFF;
            ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundNBT.getCompound("stack"));
            if (itemstack.isEmpty() || j >= this.armorInventory.size()) continue;
            this.armorInventory.set(j, (Object)itemstack);
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (!ItemStackUtils.isEmpty(stack)) {
            if (ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot))) {
                --this.freeSlots;
            }
        } else if (!ItemStackUtils.isEmpty((ItemStack)this.mainInventory.get(slot))) {
            ++this.freeSlots;
        }
        this.mainInventory.set(slot, (Object)stack);
    }

    public Iterable<ItemStack> getIterableArmorAndHandInv() {
        return Iterables.concat(this.armorInventory, List.of(this.getStackInSlot(this.mainItem), this.getStackInSlot(this.offhandItem)));
    }
}

