/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs.pirates;

import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityPirateRaider
extends AbstractEntityMinecoloniesRaider {
    private static final double PIRATE_SWIM_BONUS = 2.3;
    private static final int PIRATE_TEXTURES = 4;
    private int textureId = new Random().nextInt(4);

    public AbstractEntityPirateRaider(EntityType<? extends AbstractEntityPirateRaider> type, Level world) {
        super((EntityType<? extends AbstractEntityMinecoloniesRaider>)type, world);
    }

    @Override
    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null && this.level().random.nextInt(100) <= 1) {
            this.playSound(soundevent, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    @Override
    public int getTextureId() {
        return this.textureId;
    }

    @Override
    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        AbstractAdvancedPathNavigate navigator = super.getNavigation();
        navigator.getPathingOptions().withStartSwimCost(2.5).withSwimCost(1.1);
        return navigator;
    }

    @Override
    public RaiderType getRaiderType() {
        return RaiderType.PIRATE;
    }

    @Override
    public double getSwimSpeedFactor() {
        return 2.3;
    }
}

