/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.enchants.ModEnchants;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.items.IChiefSwordItem;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityMinecoloniesRaider
extends AbstractEntityMinecoloniesMonster
implements IThreatTableEntity,
Enemy {
    private static final float HP_PERCENT_PER_DMG = 0.03f;
    private static final int MAX_SCALED_DAMAGE = 7;
    private static final float MIN_THORNS_DAMAGE = 30.0f;
    private static final int THORNS_CHANCE = 5;
    private static final int COLONY_SET_RAIDED_CHANCE = 20;
    protected AbstractAdvancedPathNavigate newNavigator;
    private IColony colony;
    private int currentCount = 0;
    private long worldTimeAtSpawn = 0L;
    private int currentTick = 0;
    private int eventID = 0;
    private boolean isRegistered = false;
    private int invulTime = 40;
    private int envDmgCooldown = 0;
    private int envDamageInterval = 5;
    private boolean envDamageImmunity = false;
    private boolean tempEnvDamageImmunity = true;
    private int collisionCounter = 0;
    private double difficulty = 1.0;
    private ChunkPos lastChunkPos = null;

    public AbstractEntityMinecoloniesRaider(EntityType<? extends AbstractEntityMinecoloniesRaider> type, Level world) {
        this(type, world, 1);
    }

    public AbstractEntityMinecoloniesRaider(EntityType<? extends AbstractEntityMinecoloniesRaider> type, Level world, int textureCount) {
        super(type, world, textureCount);
        this.setPersistenceRequired();
        this.xpReward = 5;
        IMinecoloniesAPI.getInstance().getMobAIRegistry().applyToMob(this);
        this.setInvulnerable(true);
        RaiderMobUtils.setEquipment(this);
    }

    @Override
    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.navigation = this.newNavigator;
            this.newNavigator.setCanFloat(true);
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.getPathingOptions().setEnterDoors(true);
            this.newNavigator.getPathingOptions().withDropCost(1.0);
            this.newNavigator.getPathingOptions().withJumpCost(1.0);
            this.newNavigator.getPathingOptions().setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.4f).withBuildLeafBridges().withChanceToByPassMovingAway(0.2).withPlaceLadders();
            if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).raidersbreakblocks.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
        }
        return this.newNavigator;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.shouldDespawn() || this.level() != null && this.level().isAreaLoaded(this.blockPosition(), 3) && this.getColony() == null;
    }

    @Override
    public abstract RaiderType getRaiderType();

    private boolean shouldDespawn() {
        return this.worldTimeAtSpawn != 0L && this.level().getGameTime() - this.worldTimeAtSpawn >= 36000L;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putLong("time", this.worldTimeAtSpawn);
        compound.putInt("colony", this.colony == null ? 0 : this.colony.getID());
        compound.putInt("mc_event_id", this.eventID);
        super.addAdditionalSaveData(compound);
    }

    @Override
    @Nullable
    public Entity changeDimension(DimensionTransition dimensionTransition) {
        return null;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.getLong("time");
        this.eventID = compound.getInt("mc_event_id");
        if (compound.contains("colony") && (colonyId = compound.getInt("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.level()));
        }
        if (this.colony == null || this.eventID == 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        super.readAdditionalSaveData(compound);
    }

    @Override
    public void aiStep() {
        if (!this.isAlive()) {
            return;
        }
        this.updateSwingTime();
        if (this.invulTime > 0) {
            --this.invulTime;
        } else {
            this.setInvulnerable(false);
        }
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
        if (this.level().isClientSide) {
            super.aiStep();
            return;
        }
        if (this.currentTick % (this.random.nextInt(20) + 1) == 0) {
            --this.envDmgCooldown;
            if (this.worldTimeAtSpawn == 0L) {
                this.worldTimeAtSpawn = this.level().getGameTime();
            }
            if (this.chunkPosition() != this.lastChunkPos) {
                this.lastChunkPos = this.chunkPosition();
                if (this.random.nextInt(20) <= 0) {
                    this.onEnterChunk(this.lastChunkPos);
                }
            }
            if (this.shouldDespawn()) {
                this.die(this.level().damageSources().source(DamageSourceKeys.DESPAWN));
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (!this.isRegistered) {
                this.registerWithColony();
            }
            if (this.currentCount <= 0) {
                this.currentCount = 960;
                if (!this.getMainHandItem().isEmpty() && this.getMainHandItem().getItem() instanceof IChiefSwordItem && (Integer)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).raidDifficulty.get() >= 5) {
                    RaiderMobUtils.getBarbariansCloseToEntity((Entity)this, 7.0).stream().filter(entity -> !entity.hasEffect(MobEffects.MOVEMENT_SPEED)).forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 1)));
                }
            } else {
                --this.currentCount;
            }
        }
        ++this.currentTick;
        if (this.isRegistered) {
            super.aiStep();
        }
    }

    private void onEnterChunk(ChunkPos newChunkPos) {
        LevelChunk chunk = this.colony.getWorld().getChunk(newChunkPos.x, newChunkPos.z);
        int owningColonyId = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (owningColonyId != 0 && this.colony.getID() != owningColonyId) {
            IColony tempColony = IColonyManager.getInstance().getColonyByWorld(owningColonyId, this.level());
            tempColony.getRaiderManager().setPassThroughRaid();
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        RaiderMobUtils.setEquipment(this);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        if (!this.level().isClientSide && this.colony != null && this.eventID > 0) {
            this.colony.getEventManager().unregisterEntity((Entity)this, this.eventID);
        }
        super.remove(reason);
    }

    public IColony getColony() {
        return this.colony;
    }

    public void registerWithColony() {
        if (this.colony == null || this.eventID == 0 || this.dead) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        RaiderMobUtils.setMobAttributes(this, this.getColony());
        this.colony.getEventManager().registerEntity((Entity)this, this.eventID);
        this.isRegistered = true;
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        if (!this.level().isClientSide && this.getColony() != null) {
            this.getColony().getEventManager().onEntityDeath((LivingEntity)this, this.eventID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        if (damageSource.getDirectEntity() == null || damageSource.getDirectEntity() instanceof FakePlayer) {
            if (this.envDamageImmunity || this.tempEnvDamageImmunity) {
                return false;
            }
            if (--this.envDmgCooldown > 0) return false;
            this.envDmgCooldown = this.envDamageInterval;
            return super.hurt(damageSource, damage);
        } else {
            Entity source;
            if (this.level().isClientSide()) return super.hurt(damageSource, damage);
            IColonyEvent event = this.colony.getEventManager().getEventByID(this.eventID);
            if (event instanceof IColonyCampFireRaidEvent) {
                ((IColonyCampFireRaidEvent)((Object)event)).setCampFireTime(0);
            }
            if (!((source = damageSource.getEntity()) instanceof Player)) return super.hurt(damageSource, damage);
            Player player = (Player)source;
            if (damage > 30.0f && this.random.nextInt(5) == 0) {
                source.hurt(this.level().damageSources().thorns((Entity)this), damage * 0.5f);
            }
            float raiderDamageEnchantLevel = player.getMainHandItem().getEnchantmentLevel((Holder)((Registry)player.level().registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(ModEnchants.raiderDamage).get());
            float baseScalingDamage = Math.min(damage, 7.0f);
            float totalWithScaled = Math.max(damage, damage - baseScalingDamage + baseScalingDamage * 0.03f * this.getMaxHealth() * (1.0f + raiderDamageEnchantLevel / 5.0f));
            return super.hurt(damageSource, totalWithScaled);
        }
    }

    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
        }
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public void setEnvDamageInterval(int interval) {
        this.envDamageInterval = interval;
    }

    public void setEnvDamageImmunity(boolean immunity) {
        this.envDamageImmunity = immunity;
    }

    public void setTempEnvDamageImmunity(boolean immunity) {
        this.tempEnvDamageImmunity = immunity;
    }

    @Override
    public void initStatsFor(double baseHealth, double difficulty, double baseDamage) {
        super.initStatsFor(baseHealth, difficulty, baseDamage);
        this.difficulty = difficulty;
        this.setEnvDamageInterval((int)(2.0 * difficulty));
        if (difficulty >= 1.4) {
            this.setEnvDamageImmunity(true);
        }
    }

    @Override
    public double getDifficulty() {
        return this.difficulty;
    }

    @Override
    public int getTeamId() {
        return -1;
    }
}

