/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IModuleContainerView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuildingView
extends IRequester,
IModuleContainerView {
    @NotNull
    public BlockPos getID();

    @NotNull
    public BlockPos getPosition();

    public BlockPos getParent();

    public int getBuildingLevel();

    public List<BlockPos> getContainerList();

    public int getBuildingMaxLevel();

    public boolean isBuildingMaxLevel();

    public int getCurrentWorkOrderLevel();

    public String getStructurePath();

    public String getCustomName();

    default public String getBuildingDisplayName() {
        String customName = this.getCustomName();
        return customName.isEmpty() ? this.getBuildingType().getTranslationKey() : customName;
    }

    public String getStructurePack();

    public RotationMirror getRotationMirror();

    public boolean hasWorkOrder();

    public boolean isBuilding();

    public boolean isRepairing();

    public boolean isDeconstructing();

    public int getClaimRadius();

    public void openGui(boolean var1);

    @Nullable
    public BOWindow getWindow();

    public void deserialize(@NotNull RegistryFriendlyByteBuf var1);

    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen();

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenDataView var1, Class<R> var2);

    public ImmutableList<IRequest<?>> getOpenRequests(@NotNull ICitizenDataView var1);

    public ImmutableList<IRequest<?>> getOpenRequestsOfBuilding();

    public IColonyView getColony();

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenDataView var1, Class<R> var2, Predicate<IRequest<? extends R>> var3);

    public int getBuildingDmPrio();

    public ImmutableCollection<IToken<?>> getResolverIds();

    public void setCustomName(String var1);

    public boolean isDeconstructed();

    public BuildingEntry getBuildingType();

    public void setBuildingType(BuildingEntry var1);

    public Set<Integer> getAllAssignedCitizens();

    public boolean allowsAssignment();

    default public int getRange() {
        return 0;
    }
}

