/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.extendedae;

import appeng.core.AppEng;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbjeiextras.modspecific.GlodiumHelpers;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CrystalFixerRecipeCategory
implements IRecipeCategory<RecipeHolder<CrystalFixerRecipe>> {
    public static final RecipeType<RecipeHolder<CrystalFixerRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)CrystalFixerRecipe.TYPE);
    private static final ResourceLocation BG_ASSET = AppEng.makeId((String)"textures/xei/crystal_fixer.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.#%", new DecimalFormatSymbols());
    private final IDrawableStatic background;
    private final IDrawable icon;

    public CrystalFixerRecipeCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createDrawable(BG_ASSET, 0, 0, 114, 63);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)EAESingletons.CRYSTAL_FIXER));
    }

    public RecipeType<RecipeHolder<CrystalFixerRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"emi.extendedae.category.fixer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CrystalFixerRecipe> recipeHolder, IFocusGroup focuses) {
        CrystalFixerRecipe recipe = (CrystalFixerRecipe)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).addItemStack(new ItemStack((ItemLike)recipe.getInput()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 49, 11).addIngredients(GlodiumHelpers.of(recipe.getFuel()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 19).addItemStack(new ItemStack((ItemLike)recipe.getOutput()));
    }

    public void draw(RecipeHolder<CrystalFixerRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"emi.extendedae.text.success_chance", (Object[])new Object[]{FORMAT.format(((CrystalFixerRecipe)recipe.value()).getChance())}), 1, 2, 0x7E7E7E, false);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(41.0f, 29.0f, 0.0f);
        pose.scale(2.0f, 2.0f, 1.0f);
        guiGraphics.renderItem(new ItemStack((ItemLike)EAESingletons.CRYSTAL_FIXER), 0, 0);
        pose.popPose();
    }
}

