/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ExperienceFunctions {
    public static boolean canConsumeXp(Player ep, int xp) {
        if (ep.isCreative()) {
            return true;
        }
        return xp <= 0 || ExperienceFunctions.getPlayerXP(ep) >= xp;
    }

    public static void consumeXp(Player ep, int xp) {
        if (xp <= 0) {
            return;
        }
        int playerXP = ExperienceFunctions.getPlayerXP(ep);
        if (playerXP >= xp) {
            ExperienceFunctions.addPlayerXP(ep, -xp);
        }
        if (ep instanceof ServerPlayer) {
            ((ServerPlayer)ep).connection.send((Packet)new ClientboundEntityEventPacket((Entity)ep, 9));
        }
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)ExperienceFunctions.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = ExperienceFunctions.getPlayerXP(player) + amount;
        player.experienceLevel = ExperienceFunctions.getLevelForExperience(experience);
        int expForLevel = ExperienceFunctions.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceFunctions.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceFunctions.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceFunctions.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceFunctions.sum(level - 30, 112, 9);
    }
}

