/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.config.client.gui.widget;

import dev.isxander.yacl3.gui.image.ImageRendererManager;
import dev.isxander.yacl3.gui.image.impl.AnimatedDynamicTextureImage;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.lwjgl.opengl.GL20;

public class ImageButtonWidget
extends AbstractWidget {
    float durationHovered = 1.0f;
    private final CompletableFuture<AnimatedDynamicTextureImage> image;
    private final Consumer<AbstractWidget> onPress;

    public ImageButtonWidget(int x, int y, int width, int height, Component message, ResourceLocation image, Consumer<AbstractWidget> clickEvent) {
        super(x, y, width, height, message);
        this.image = ImageRendererManager.registerOrGetImage((ResourceLocation)image, () -> AnimatedDynamicTextureImage.createWEBPFromTexture((ResourceLocation)image));
        this.onPress = clickEvent;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        this.durationHovered = this.isHovered() || this.isFocused() ? (this.durationHovered += delta / 2.0f) : (this.durationHovered < 0.0f ? 0.0f : (this.durationHovered -= this.durationHovered / 4.0f));
        float alphaScale = Mth.clampedLerp((float)0.7f, (float)0.2f, (float)Mth.clamp((float)(this.durationHovered - 1.0f), (float)0.0f, (float)1.0f));
        if (this.image.isDone()) {
            int minFilterScalingTypePrev = GL20.glGetTexParameteri((int)3553, (int)10241);
            int magFilterScalingTypePrev = GL20.glGetTexParameteri((int)3553, (int)10240);
            try {
                AnimatedDynamicTextureImage contentImage = this.image.get();
                if (contentImage != null) {
                    try {
                        Field frameWidthField = contentImage.getClass().getDeclaredField("frameWidth");
                        frameWidthField.setAccessible(true);
                        int frameWidth = frameWidthField.getInt(contentImage);
                        Field frameHeightField = contentImage.getClass().getDeclaredField("frameHeight");
                        frameHeightField.setAccessible(true);
                        int frameHeight = frameHeightField.getInt(contentImage);
                        float neededWidth = (float)frameWidth * ((float)this.height / (float)frameHeight);
                        context.pose().pushPose();
                        GL20.glTexParameteri((int)3553, (int)10241, (int)9729);
                        GL20.glTexParameteri((int)3553, (int)10240, (int)9729);
                        contentImage.render(context, this.getX(), this.getY(), (int)Math.max(neededWidth, (float)this.width), delta);
                        context.pose().popPose();
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException | ExecutionException contentImage) {
            }
            finally {
                GL20.glTexParameteri((int)3553, (int)10241, (int)minFilterScalingTypePrev);
                GL20.glTexParameteri((int)3553, (int)10240, (int)magFilterScalingTypePrev);
            }
        }
        int greyColor = FastColor.ABGR32.color((int)((int)(alphaScale * 255.0f)), (int)0, (int)0, (int)0);
        context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, greyColor);
        Minecraft client = Minecraft.getInstance();
        float fontScaling = 1.24f;
        int unscaledTextX = this.getX() + 5;
        int n = this.getY() + this.height;
        Objects.requireNonNull(client.font);
        int unscaledTextY = n - 9 - 5;
        int textX = (int)((float)unscaledTextX / fontScaling);
        int textY = (int)((float)unscaledTextY / fontScaling);
        int endX = (int)((float)(this.getX() + this.width - 5) / fontScaling);
        int endY = (int)((float)(this.getY() + this.height - 5) / fontScaling);
        Objects.requireNonNull(client.font);
        context.fill(unscaledTextX - 5, unscaledTextY - 5, unscaledTextX + this.width - 5, unscaledTextY + 9 + 5, -1358954496);
        context.pose().pushPose();
        context.pose().scale(fontScaling, fontScaling, 1.0f);
        ImageButtonWidget.renderScrollingString((GuiGraphics)context, (Font)client.font, (Component)this.getMessage(), (int)textX, (int)textY, (int)endX, (int)endY, (int)-1);
        context.pose().popPose();
        context.renderOutline(this.getX(), this.getY(), this.width, this.height, 0xFFFFFFF);
        context.disableScissor();
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.HINT, this.getMessage());
    }
}

