/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.recipe;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class CopyComponentsRecipe
extends ShapedRecipe {
    public static final MapCodec<CopyComponentsRecipe> CODEC = new MapCodec<CopyComponentsRecipe>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(ShapedRecipe.Serializer.CODEC.keys(ops), Stream.of(ops.createString("components"), ops.createString("copyIndex")));
        }

        public <T> DataResult<CopyComponentsRecipe> decode(DynamicOps<T> ops, MapLike<T> input) {
            return ShapedRecipe.Serializer.CODEC.decode(ops, input).flatMap(recipe -> ops.getNumberValue(input.get("copyIndex")).flatMap(ci -> ops.getList(input.get("components")).map(comp -> {
                ArrayList components = new ArrayList();
                comp.accept(t -> components.add((DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)((String)ops.getStringValue(t).getOrThrow())))));
                return new CopyComponentsRecipe((ShapedRecipe)recipe, ci.intValue(), components);
            })));
        }

        public <T> RecordBuilder<T> encode(CopyComponentsRecipe input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            RecordBuilder builder = ShapedRecipe.Serializer.CODEC.encode((Object)input.wrapped, ops, prefix);
            builder.add("copyIndex", ops.createInt(input.copyIndex));
            builder.add("components", ops.createList(input.components.stream().map(c -> ops.createString(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(c).toString()))));
            return builder;
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, CopyComponentsRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CopyComponentsRecipe>(){

        public CopyComponentsRecipe decode(RegistryFriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)ShapedRecipe.Serializer.STREAM_CODEC.decode((Object)buffer);
            return new CopyComponentsRecipe(recipe, buffer.readVarInt(), buffer.readList((StreamDecoder)ByteBufCodecs.idMapper((IdMap)BuiltInRegistries.DATA_COMPONENT_TYPE)));
        }

        public void encode(RegistryFriendlyByteBuf buffer, CopyComponentsRecipe value) {
            ShapedRecipe.Serializer.STREAM_CODEC.encode((Object)buffer, (Object)value.wrapped);
            buffer.writeVarInt(value.copyIndex);
            buffer.writeCollection(value.components, (StreamEncoder)ByteBufCodecs.idMapper((IdMap)BuiltInRegistries.DATA_COMPONENT_TYPE));
        }
    };
    private final ShapedRecipe wrapped;
    private final int copyIndex;
    private final List<DataComponentType<?>> components;

    public CopyComponentsRecipe(ShapedRecipe other, int copyIndex, List<DataComponentType<?>> components) {
        super(other.getGroup(), other.category(), other.pattern, other.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
        this.wrapped = other;
        this.copyIndex = copyIndex;
        this.components = components;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = this.wrapped.assemble(input, registries);
        ItemStack base = input.getItem(this.copyIndex);
        for (DataComponentType<?> type : this.components) {
            Object component = base.get(type);
            if (component == null) continue;
            result.set(type, component);
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FunctionalStorage.COPY_COMPONENTS_SERIALIZER.value();
    }

    @SafeVarargs
    public static RecipeOutput output(final RecipeOutput output, final int copyIndex, final DataComponentType<?> ... components) {
        return new RecipeOutput(){

            public Advancement.Builder advancement() {
                return output.advancement();
            }

            public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
                output.accept(id, (Recipe)new CopyComponentsRecipe((ShapedRecipe)recipe, copyIndex, Arrays.asList(components)), advancement, conditions);
            }
        };
    }
}

