/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerProperties;
import com.buuz135.functionalstorage.client.gui.FluidDrawerInfoGuiAddon;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDrawerTile
extends ControllableDrawerTile<FluidDrawerTile> {
    @Save
    public BigFluidHandler fluidHandler;
    private final FunctionalStorage.DrawerType type;

    public FluidDrawerTile(BasicTileBlock<FluidDrawerTile> base, BlockEntityType<FluidDrawerTile> blockEntityType, BlockPos pos, BlockState state, FunctionalStorage.DrawerType type) {
        super(base, blockEntityType, pos, state, new DrawerProperties(type.getSlotAmount(), FSAttachments.FLUID_STORAGE_MODIFIER));
        this.type = type;
        this.fluidHandler = new BigFluidHandler(type.getSlots(), this.getTankCapacity(this.getStorageMultiplier())){

            @Override
            public void onChange() {
                FluidDrawerTile.this.syncObject(FluidDrawerTile.this.fluidHandler);
            }

            @Override
            public boolean isDrawerLocked() {
                return FluidDrawerTile.this.isLocked();
            }

            @Override
            public boolean isDrawerVoid() {
                return FluidDrawerTile.this.isVoid();
            }

            @Override
            public boolean isDrawerCreative() {
                return FluidDrawerTile.this.isCreative();
            }
        };
    }

    private int getTankCapacity(double storageMultiplier) {
        return (int)Math.min(2.147483647E9, Math.floor(storageMultiplier * 1000.0));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        String slotName = "";
        if (this.type.getSlots() == 2) {
            slotName = "_2";
        }
        if (this.type.getSlots() == 4) {
            slotName = "_4";
        }
        String finalSlotName = slotName;
        this.addGuiAddonFactory(() -> new FluidDrawerInfoGuiAddon(64, 16, Utils.resourceLocation("functionalstorage", "textures/block/fluid_front" + finalSlotName + ".png"), this.type.getSlots(), this.type.getSlotPosition(), this::getFluidHandler, integer -> this.getFluidHandler().getTankCapacity((int)integer)));
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (slot != -1 && !playerIn.getItemInHand(hand).isEmpty()) {
            InteractionResult interactionResult;
            Optional fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack.isPresent() && this.fluidHandler.isDrawerLocked() && this.fluidHandler.isFluidValid(slot, new FluidStack(Fluids.EMPTY, 0))) {
                this.fluidHandler.getFilterStack()[slot] = (FluidStack)fluidStack.get();
                this.markForUpdate();
            }
            if ((interactionResult = Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).map(iFluidHandlerItem -> Optional.ofNullable((IItemHandler)playerIn.getCapability(Capabilities.ItemHandler.ENTITY)).map(iItemHandler -> {
                FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.setItemInHand(hand, result.getResult().copy());
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS)) == InteractionResult.SUCCESS) {
                return interactionResult;
            }
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public void onClicked(Player playerIn, int slot) {
        ItemStack stack = playerIn.getItemInHand(InteractionHand.MAIN_HAND);
        if (slot != -1 && !stack.isEmpty()) {
            Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(iFluidHandlerItem -> Optional.ofNullable((IItemHandler)playerIn.getCapability(Capabilities.ItemHandler.ENTITY)).ifPresent(iItemHandler -> {
                FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.setItemInHand(InteractionHand.MAIN_HAND, result.getResult());
                }
            }));
        }
    }

    @NotNull
    public FluidDrawerTile getSelf() {
        return this;
    }

    public FunctionalStorage.DrawerType getDrawerType() {
        return this.type;
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    public BigFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.fluidHandler.lockHandler();
        this.syncObject(this.fluidHandler);
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            if (this.getFluidHandler().getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryEmpty() {
        for (int i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            if (this.getFluidHandler().getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        return false;
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<FluidDrawerTile>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<FluidDrawerTile>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (FluidDrawerTile.this.isStorageUpgradeLocked()) {
                    return ItemStack.EMPTY;
                }
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.has(FSAttachments.FLUID_STORAGE_MODIFIER)) {
                    ItemStack[] replacement = new ItemStack[this.getSlots()];
                    replacement[slot] = ItemStack.EMPTY;
                    float newSize = SizeProvider.calculateAsFactor((IItemHandler)this, FSAttachments.FLUID_STORAGE_MODIFIER, FluidDrawerTile.this.baseSize, replacement);
                    if (!FluidDrawerTile.this.canChangeMultiplier(newSize)) {
                        return ItemStack.EMPTY;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (this.isStorageUpgradeLocked()) {
                return false;
            }
            if (stack.getItem().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                return true;
            }
            return stack.has(FSAttachments.FLUID_STORAGE_MODIFIER) || stack.is(FunctionalStorage.CREATIVE_UPGRADE);
        }).setOnSlotChanged((stack, integer) -> {
            this.setNeedsUpgradeCache(true);
            this.fluidHandler.setCapacity(this.getTankCapacity(this.getStorageMultiplier()));
            this.syncObject(this.fluidHandler);
        }).setSlotLimit(1);
    }

    protected boolean canChangeMultiplier(double newSizeMultiplier) {
        for (int i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            FluidStack stored = this.getFluidHandler().getFluidInTank(i);
            if (stored.isEmpty() || stored.getAmount() <= Math.min(Integer.MAX_VALUE, this.getTankCapacity(newSizeMultiplier))) continue;
            return false;
        }
        return true;
    }

    public IFluidHandler getFluidHandler(@Nullable Direction direction) {
        return this.fluidHandler;
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return null;
    }
}

