/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.neoforged.neoforge.fluids.FluidStack;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class ComponentFluid
implements ICustomComponent {
    private transient List<FluidStack> fluidStacks;
    private transient WidgetTank tankWidget;
    private transient int scaleParsed = 16000;
    public IVariable fluid;
    public IVariable scale;

    public void build(int componentX, int componentY, int pageNum) {
        this.tankWidget = new WidgetTank(componentX, componentY, 16, 64, this.fluidStacks.isEmpty() ? FluidStack.EMPTY : this.fluidStacks.getFirst(), this.scaleParsed);
    }

    public void render(GuiGraphics graphics, IComponentRenderContext ctx, float pticks, int mouseX, int mouseY) {
        if (!this.fluidStacks.isEmpty()) {
            this.tankWidget.setFluid(this.fluidStacks.get(ctx.getTicksInBook() / 20 % this.fluidStacks.size()));
        }
        if (this.tankWidget.getTank().getCapacity() > 0 && !this.tankWidget.getTank().getFluid().isEmpty()) {
            this.tankWidget.renderWidget(graphics, mouseX, mouseY, pticks);
            if (ctx.isAreaHovered(mouseX, mouseY, this.tankWidget.getX(), this.tankWidget.getY(), this.tankWidget.getWidth(), this.tankWidget.getHeight())) {
                ctx.setHoverTooltipComponents(this.tankWidget.makeTooltip());
            }
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider provider) {
        this.fluidStacks = ((IVariable)lookup.apply(this.fluid)).asStreamOrSingleton(provider).map(x -> (FluidStack)x.as(FluidStack.class)).collect(Collectors.toList());
        String scaleStr = ((IVariable)lookup.apply(this.scale)).asString();
        try {
            this.scaleParsed = Integer.parseInt(scaleStr);
        }
        catch (NumberFormatException e) {
            this.scaleParsed = 0;
        }
    }
}

